% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_votes_by_date.R
\name{get_votes_by_date}
\alias{get_votes_by_date}
\title{Get Votes by Date}
\usage{
get_votes_by_date(
  chamber = c("house", "senate"),
  year,
  month,
  page = 1,
  myAPI_Key
)
}
\arguments{
\item{chamber}{house or senate}

\item{year}{YYYY format}

\item{month}{MM format}

\item{page}{Results come in batches of 20. The page parameter specifies which one to retrieve.}

\item{myAPI_Key}{API key from Propublica To use the congress API, you must sign up for an API key.}
}
\value{
List of returned JSON from endpoint that retrieves all votes for one or both chambers in a particular month
s
}
\description{
HTTP Requests: GET https://api.propublica.org/congress/v1/{chamber}/votes/{year}/{month}.json
}
\examples{
\dontrun{
get_votes_by_date('house', 2018, '09')
}
}
