% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{trackerFlag}
\alias{trackerFlag}
\alias{trackerFlag,PTModule-method}
\alias{trackerFlag<-}
\alias{trackerFlag<-,PTModule-method}
\title{Tracker flag indicating version compatibility}
\usage{
\S4method{trackerFlag}{PTModule}(x)

\S4method{trackerFlag}{PTModule}(x) <- value
}
\arguments{
\item{x}{A \code{\link{PTModule}} object for which the flag needs to
returned or replaced.}

\item{value}{A \code{character} string representing the tracker flag with which
that of object \code{x} needs to be replaced with. Should either be "\code{M.K.}"
or "\code{M!K!}". Note that if a current flag "\code{M!K!}" is
replaced by "\code{M.K.}", \code{\link{PTPattern}}s may get lost as the
latter supports less patterns.}
}
\value{
For \code{trackerFlag}, the tracker flag of object \code{x} is returned.

For \code{trackerFlag<-}, a copy of object \code{x} with an updated tracker
flag is returned.
}
\description{
Method to obtain a tracker flag, which indicates the version compatibility
of a ProTracker module (\code{\link{PTModule}} object).
}
\details{
ProTrackR supports two tracker flags: "\code{M.K.}" and "\code{M!K!}". M.K.
are presumably the initials of programmers Mahony and Kaktus, unfortunately
documentation on this matter is ambiguous. In any case, modules with the
flag "\code{M.K.}" can hold up to 64 patterns, whereas modules with the flag
"\code{M!K!}" can hold up to 100 patterns. Use this method to obtain or
replace the tracker flag of a \code{\link{PTModule}}.
}
\examples{
data("mod.intro")

## the current trackerFlag of mod.intro is "M.K.",
## meaning that it can hold a maximum of 64 patterns:
trackerFlag(mod.intro)

patternOrder(mod.intro, full = TRUE) <- 0:63

## If we upgrade the trackerFlag of mod.intro to "M!K!"
## it can hold a maximum of 100 patterns!:
trackerFlag(mod.intro) <- "M!K!"

patternOrder(mod.intro, full = TRUE) <- 0:99

## Now let's do something dangerous:
## current flag is "M!K!", by setting it
## back to "M.K.", patterns 65:100 are lost...
trackerFlag(mod.intro) <- "M.K."
}
\author{
Pepijn de Vries
}
\seealso{
Other module.operations: \code{\link{PTModule}},
  \code{\link{PTModule-class}};
  \code{\link{appendPattern}},
  \code{\link{appendPattern,PTModule,PTPattern-method}};
  \code{\link{deletePattern}},
  \code{\link{deletePattern,PTModule,numeric-method}};
  \code{\link{moduleSize}},
  \code{\link{moduleSize,PTModule-method}};
  \code{\link{patternLength}},
  \code{\link{patternLength,PTModule-method}};
  \code{\link{patternOrderLength}},
  \code{\link{patternOrderLength,PTModule-method}},
  \code{\link{patternOrderLength<-}},
  \code{\link{patternOrderLength<-,PTModule,numeric-method}};
  \code{\link{patternOrder}},
  \code{\link{patternOrder,PTModule-method}},
  \code{\link{patternOrder<-}},
  \code{\link{patternOrder<-,PTModule,ANY,numeric-method}};
  \code{\link{read.module}},
  \code{\link{read.module,ANY-method}},
  \code{\link{read.module,character-method}};
  \code{\link{write.module}},
  \code{\link{write.module,PTModule,ANY-method}},
  \code{\link{write.module,PTModule,character-method}}
}

