% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_met.R
\name{bayes_met}
\alias{bayes_met}
\title{Bayesian model for multi-environment trials}
\usage{
bayes_met(
  data,
  gen,
  loc,
  repl,
  trait,
  reg = NULL,
  year = NULL,
  res.het = FALSE,
  iter = 2000,
  cores = 1,
  chains = 4,
  pars = NA,
  warmup = floor(iter/2),
  thin = 1,
  seed = sample.int(.Machine$integer.max, 1),
  init = "random",
  verbose = FALSE,
  algorithm = c("NUTS", "HMC", "Fixed_param"),
  control = NULL,
  include = TRUE,
  show_messages = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame in which to interpret the variables declared in the other arguments.}

\item{gen, loc}{A string. The name of the columns that contain the evaluated
candidates and locations (or environments, if you are working with factor combinations), respectively.}

\item{repl}{A string, a vector, or \code{NULL}. If the trial is randomized in complete blocks design,
\code{repl} will be a string representing the name of the column that corresponds to the blocks.
If the trial is randomized in incomplete blocks design, \code{repl} will be a string vector
containing the name of the columns that correspond to the replicate and block effects on
the first and second positions, respectively (\code{c(replicate, block)}).
If the data does not have replicates, \code{repl} must be \code{NULL}.}

\item{trait}{A string. The analysed variable. Currently, only single-trait models are fitted.}

\item{reg}{A string or NULL. The name of the column that contain information on
regions or mega-environments. \code{NULL} (default) if not applicable.}

\item{year}{A string or NULL. The name of the column that contain information on
years (or seasons). \code{NULL} (default) if not applicable.}

\item{res.het}{Should the model consider heterogeneous residual variances?
Defaults for \code{FALSE}. If \code{TRUE}, the model will estimate one
residual variance per location (or environmnet).}

\item{iter}{A positive integer specifying the number of iterations for each 
    chain (including warmup). The default is 2000.}

\item{cores}{Number of cores to use when executing the chains in parallel,
    which defaults to 1 but we recommend setting the \code{mc.cores} option 
    to be as many processors as the hardware and RAM allow (up to the 
    number of chains).}

\item{chains}{A positive integer specifying the number of Markov chains. 
    The default is 4.}

\item{pars}{A vector of character strings specifying parameters of interest. 
    The default is \code{NA} indicating all parameters in the model. 
    If \code{include = TRUE}, only samples for parameters named in \code{pars} 
    are stored in the fitted results. Conversely, if \code{include = FALSE}, 
    samples for all parameters \emph{except} those named in \code{pars} are 
    stored in the fitted results.}

\item{warmup}{A positive integer specifying the number of warmup (aka burnin)
    iterations per chain. If step-size adaptation is on (which it is by default), 
    this also controls the number of iterations for which adaptation is run (and
    hence these warmup samples should not be used for inference). The number of 
    warmup iterations should be smaller than \code{iter} and the default is
    \code{iter/2}.}

\item{thin}{A positive integer specifying the period for saving samples. 
    The default is 1, which is usually the recommended value.}

\item{seed}{The seed for random number generation. The default is generated 
    from 1 to the maximum integer supported by \R on the machine. Even if 
    multiple chains are used, only one seed is needed, with other chains having 
    seeds derived from that of the first chain to avoid dependent samples.
    When a seed is specified by a number, \code{as.integer} will be applied to it. 
    If \code{as.integer} produces \code{NA}, the seed is generated randomly. 
    The seed can also be specified as a character string of digits, such as
    \code{"12345"}, which is converted to integer.}

\item{init}{Initial values specification. See the detailed documentation for 
    the init argument in \code{\link[rstan]{stan}}.}

\item{verbose}{\code{TRUE} or \code{FALSE}: flag indicating whether 
    to print intermediate output from Stan on the console, which might
    be helpful for model debugging.}

\item{algorithm}{One of sampling algorithms that are implemented in Stan. 
    Current options are \code{"NUTS"} (No-U-Turn sampler, Hoffman and Gelman 2011, Betancourt 2017), 
    \code{"HMC"} (static HMC), or \code{"Fixed_param"}. The default and 
    preferred algorithm is \code{"NUTS"}.}

\item{control}{A named \code{list} of parameters to control the sampler's
    behavior. See the details in the documentation for the \code{control} argument
    in \code{\link[rstan]{stan}}.}

\item{include}{Logical scalar defaulting to \code{TRUE} indicating
    whether to include or exclude the parameters given by the 
    \code{pars} argument. If \code{FALSE}, only entire multidimensional
    parameters can be excluded, rather than particular elements of them.}

\item{show_messages}{Either a logical scalar (defaulting to \code{TRUE})
    indicating whether to print the summary of Informational Messages to
    the screen after a chain is finished or a character string naming a path
    where the summary is stored. Setting to \code{FALSE} is not recommended
    unless you are very sure that the model is correct up to numerical 
    error.}

\item{...}{Additional arguments can be \code{chain_id}, \code{init_r}, 
    \code{test_grad}, \code{append_samples}, \code{refresh},
    \code{enable_random_init}. See the documentation in \code{\link[rstan]{stan}}.}
}
\value{
An object of S4 class \code{stanfit} representing
   the fitted results. Slot \code{mode} for this object
   indicates if the sampling is done or not.
}
\description{
Fits a Bayesian multi-environment model using \code{rstan}, the \code{R} interface to \code{Stan}.
}
\details{
The function has nine available models, which will be fitted according to the
options set in the arguments:
\enumerate{
\item{Entry-mean model} : fitted when \code{repl = NULL}, \code{reg = NULL} and \code{year = NULL}:
\deqn{y = \mu + g + l + \varepsilon}
Where \eqn{y} is the phenotype, \eqn{\mu} is the intercept, \eqn{g} is the genotypic
effect, \eqn{l} is the location (or environment) effect, and \eqn{\varepsilon} is
the error (which contains the genotype-by-location interaction, in this case).

\item{Randomized complete blocks design} : fitted when \code{repl} is a single string.
It will fit different models depending if \code{reg} and \code{year} are \code{NULL}:
\itemize{
\item{\code{reg = NULL} and \code{year = NULL}} :
\deqn{y = \mu + g + l + gl + r + \varepsilon}
where \eqn{gl} is the genotype-by-location effect, and \eqn{r} is the replicate effect.
\item{\code{reg = "reg"} and \code{year = NULL}} :
\deqn{y = \mu + g + m + l + gl + gm + r + \varepsilon}
where \eqn{m} is the region effect, and \eqn{gm} is the genotype-by-region effect.
\item{\code{reg = NULL} and \code{year = "year"}} :
\deqn{y = \mu + g + t + l + gl + gt + r + \varepsilon}
where \eqn{t} is the year effect, and \eqn{gt} is the genotype-by-year effect.
\item{\code{reg = "reg"} and \code{year = "year"}} :
\deqn{y = \mu + g + m + t + l + gl + gm + gt + r + \varepsilon}
}

\item{Incomplete blocks design} : fitted when \code{repl} is a string vector of size 2.
It will fit different models depending if \code{reg} and \code{year} are \code{NULL}:
\itemize{
\item{\code{reg = NULL} and \code{year = NULL}} :
\deqn{y = \mu + g + l + gl + r + b + \varepsilon}
where \eqn{b} is the block within replicates effect.
\item{\code{reg = "reg"} and \code{year = NULL}} :
\deqn{y = \mu + g + m + l + gl + gm + r + b + \varepsilon}
\item{\code{reg = NULL} and \code{year = "year"}} :
\deqn{y = \mu + g + t + l + gl + gt + r + b + \varepsilon}
\item{\code{reg = "reg"} and \code{year = "year"}} :
\deqn{y = \mu + g + m + t + l + gl + gm + gt + r + b + \varepsilon}
}

}
The models described above have predefined priors:
\deqn{x \sim \mathcal{N} \left( 0, S^{[x]} \right)}
\deqn{\sigma \sim \mathcal{HalfCauchy}\left( 0, S^{[\sigma]} \right)}
where \eqn{x} can be any effect but the error, and \eqn{\sigma} is the standard
deviation of the likelihood. If \code{res.het = TRUE}, then \eqn{\sigma_k \sim \mathcal{HalfCauchy}\left( 0, S^{\left[ \sigma_k \right]} \right)}.
The hyperpriors are set as follows:
\deqn{S^{[x]} \sim \mathcal{HalfCauchy}\left( 0, \phi \right)}
where \eqn{\phi} is the known global hyperparameter defined such as \eqn{\phi = max(y) \times 10}.

More details about the usage of \code{bayes_met} and other functions of
the \code{ProbBreed} package can be found at \url{https://saulo-chaves.github.io/ProbBreed_site/}.
Solutions to convergence or mixing issues can be found at
\url{https://mc-stan.org/misc/warnings.html}.
}
\section{Methods}{

  \describe{
    \item{\code{sampling}}{\code{signature(object = "stanmodel")}
      Call a sampler (NUTS, HMC, or Fixed_param depending on parameters) 
      to draw samples from the model defined by S4 class \code{stanmodel} 
      given the data, initial values, etc. 
    }
  }

}

\examples{
\donttest{
mod = bayes_met(data = maize,
                gen = "Hybrid",
                loc = "Location",
                repl = c("Rep","Block"),
                trait = "GY",
                reg = "Region",
                year = NULL,
                res.het = TRUE,
                iter = 2000, cores = 2, chain = 4)
}
}
\seealso{
\link[rstan:stanmodel-method-sampling]{rstan::sampling}, \link[rstan:stan]{rstan::stan}, \link[rstan:stanfit-class]{rstan::stanfit}
}
