\name{sql.reader}
\alias{sql.reader}
\title{Read a database described in a...}
\usage{sql.reader(data.file, filename, variable.name)}

\description{
  Read a database described in a .sql file.
}

\details{
  This function will load data from a SQL database based on
  configuration information found in the specified .sql
  file. The .sql file must specify a database to be
  accessed. All tables from the database, one specific
  tables or one specific query against any set of tables
  may be executed to generate a data set.

  Examples of the DCF format and settings used in a .sql
  file are shown below:

  Example 1 type: mysql user: sample_user password:
  sample_password host: localhost dbname: sample_database
  table: sample_table

  Example 2 type: sqlite dbname: /path/to/sample_database
  table: sample_table

  Example 3 type: sqlite dbname: /path/to/sample_database
  query: SELECT * FROM users WHERE user_active == 1

  Example 4 type: sqlite dbname: /path/to/sample_database
  table: *
}
\value{No value is returned; this function is called for its side effects.}
\arguments{
  \item{data.file}{The name of the data file to be read.}
  \item{filename}{The path to the data set to be loaded.}
  \item{variable.name}{The name to be assigned to in the global environment.}
}
\examples{library('ProjectTemplate')

#sql.reader('example.sql', 'data/example.sql', 'example')}
