% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pug_rest.R
\name{get_pug_rest}
\alias{get_pug_rest}
\title{Retrieve Data from PubChem PUG REST API}
\usage{
get_pug_rest(
  identifier = NULL,
  namespace = "cid",
  domain = "compound",
  operation = NULL,
  output = "JSON",
  searchtype = NULL,
  property = NULL,
  options = NULL,
  saveFile = FALSE,
  saveImage = FALSE,
  dpi = 300
)
}
\arguments{
\item{identifier}{A single identifier for the query, either numeric or character.}

\item{namespace}{A character string specifying the namespace for the request. Default is 'cid'.}

\item{domain}{A character string specifying the domain for the request. Default is 'compound'.}

\item{operation}{An optional character string specifying the operation for the request.}

\item{output}{A character string specifying the output format. Possible values are 'JSON', 'JSONP', 'XML', 'CSV', 'TXT', and 'PNG'. Default is 'JSON'.}

\item{searchtype}{An optional character string specifying the search type.}

\item{property}{An optional character string specifying the property for the request.}

\item{options}{A list of additional options for the request.}

\item{saveFile}{A logical value indicating whether to save the output as a file. Default is FALSE.}

\item{saveImage}{A logical value indicating whether to save the output as an image. Default is FALSE.}

\item{dpi}{An integer specifying the DPI for image output. Default is 300.}
}
\value{
Depending on the output format, this function returns different types of content:
        JSON or JSONP format returns parsed JSON content.
        XML format returns an XML object.
        CSV format returns a data frame.
        TXT format returns a table.
        PNG format returns an image object or saves an image file.
}
\description{
This function sends a request to the PubChem PUG REST API to retrieve various types of data
for a given identifier. It supports fetching data in different formats and allows saving the output.
}
\examples{
  get_pug_rest(identifier = "2244", namespace = "cid", domain = "compound", output = "JSON")

}
