% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funds_points.R
\name{plot_funds_points}
\alias{plot_funds_points}
\title{Visualization of point data.}
\usage{
plot_funds_points(data, var)
}
\arguments{
\item{data}{Dataset of class 'data.frame' containing the information about the coordinates of municipalities. Data can be retrieved from all the retrieval functions using the \code{geo_ref = "C"} argument.}

\item{var}{character. Specify the variable to visualize.}
}
\value{
Return a \code{leaflet} object representing an interactive map of centroids of muicipalities.
}
\description{
The \code{plot_funds_points} function is designed for visualizing maps of centroids for municipalities using point data. The map colors are determined by the financing amount, and the radius of each point is proportional to the corresponding financing amount.
}
\examples{
data(RENDISpoint)
plot_funds_points(RENDISpoint, var = "Finance")
#Plotting the points of each municipality of the Basilicata region using the leaflet function.

}
\author{
Lorena Ricciotti
}
