% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{significance_funnel}
\alias{significance_funnel}
\title{Make significance funnel plot}
\usage{
significance_funnel(
  yi,
  vi,
  sei,
  favor_positive = TRUE,
  alpha_select = 0.05,
  plot_pooled = TRUE,
  est_all = NA,
  est_worst = NA,
  xmin = min(yi),
  xmax = max(yi),
  ymin = 0,
  ymax = max(sqrt(vi)),
  xlab = "Point estimate",
  ylab = "Estimated standard error"
)
}
\arguments{
\item{yi}{A vector of point estimates to be meta-analyzed.}

\item{vi}{A vector of estimated variances (i.e., squared standard errors) for
the point estimates.}

\item{sei}{A vector of estimated standard errors for the point estimates.
(Only one of \code{vi} or \code{sei} needs to be specified).}

\item{favor_positive}{\code{TRUE} if publication bias are
assumed to favor significant positive estimates; \code{FALSE} if assumed to
favor significant negative estimates.}

\item{alpha_select}{Alpha level at which an estimate's probability of being
favored by publication bias is assumed to change (i.e.,
the threshold at which study investigators, journal editors, etc., consider
an estimate to be significant).}

\item{plot_pooled}{Should the pooled estimates within all studies and within
only the nonaffirmative studies be plotted as well?}

\item{est_all}{Regular meta-analytic estimate among all studies (optional).}

\item{est_worst}{Worst-case meta-analytic estimate among only nonaffirmative
studies (optional).}

\item{xmin}{x-axis (point estimate) lower limit for plot.}

\item{xmax}{x-axis (point estimate) upper limit for plot.}

\item{ymin}{y-axis (standard error) lower limit for plot.}

\item{ymax}{y-axis (standard error) upper limit for plot.}

\item{xlab}{Label for x-axis (point estimate).}

\item{ylab}{Label for y-axis (standard error).}
}
\description{
Creates a modified funnel plot that distinguishes between affirmative and
nonaffirmative studies, helping to detect the extent to which the
nonaffirmative studies' point estimates are systematically smaller than the
entire set of point estimates. The estimate among only nonaffirmative studies
(gray diamond) represents a corrected estimate under worst-case publication
bias. If the gray diamond represents a negligible effect size or if it is
much smaller than the pooled estimate among all studies (black diamond), this
suggests that the meta-analysis may not be robust to extreme publication
bias. Numerical sensitivity analyses (via \code{\link[=pubbias_svalue]{pubbias_svalue()}}) should still be
carried out for more precise quantitative conclusions.
}
\details{
By default (\code{plot_pooled = TRUE}), also plots the pooled point
estimate within all studies, supplied by the user as \code{est_all} (black
diamond), and within only the nonaffirmative studies, supplied by the user
as \code{est_worst} (gray diamond). The user can calculate \code{est_all} and
\code{est_worst} using their choice of meta-analysis model. If instead these
are not supplied but \code{plot_pooled = TRUE}, these pooled estimates will
be automatically calculated using a fixed-effects (a.k.a. "common-effect")
model.
}
\examples{
##### Make Significance Funnel #####
# compute meta-analytic effect sizes for an example dataset
require(metafor)
dat <- metafor::escalc(measure = "RR", ai = tpos, bi = tneg, ci = cpos,
                       di = cneg, data = dat.bcg)

# favor_positive = FALSE since we think publication bias is in favor of negative
significance_funnel(yi = dat$yi, vi = dat$vi, favor_positive = FALSE)
}
\references{
\insertRef{mathur2020}{metabias}
}
