% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-SM.R
\name{method.SM}
\alias{method.SM}
\title{SM (Selection Models) Method}
\usage{
\method{method}{SM}(method_name, data, settings)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes) and sei (standard errors)}

\item{settings}{List of method settings (see Details)}
}
\value{
Data frame with SM results
}
\description{
Implements selection models for publication bias correction in meta-analysis.
The method first fits a random effects meta-analysis model, then applies
selection modeling to adjust for publication bias using the metafor package.
Selection models account for the probability that studies are published
based on their p-values or effect sizes. See
\insertCite{vevea1995general;textual}{PublicationBiasBenchmark} for details.
}
\details{
The following settings are implemented \describe{
\item{\code{"default"} or \code{"3PSM"}}{3-parameter step function selection model with
Maximum Likelihood estimator (\code{method = "ML"}) and one step
at one-sided p = 0.025 (i.e., selection for significance))}
\item{\code{"4PSM"}}{4-parameter step function selection model with
Maximum Likelihood estimator (\code{method = "ML"}) and two steps
at one-sided p = 0.025 and p = 0.50 (i.e., selection for significance
and direction of the effect)}
}
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply SM method
result <- run_method("SM", data, "3PSM")
print(result)

}
\references{
\insertAllCited{}
}
