% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{apply_user_cleanup}
\alias{apply_user_cleanup}
\title{Applies manual cleanup to the data}
\usage{
apply_user_cleanup(data = data, LogFile = NULL)
}
\arguments{
\item{data}{A data frame object created from \code{downsample}.}

\item{LogFile}{A character string indicating the name (and location) of the
log file.}
}
\value{
An object of type data table as described in \link[tibble]{tibble}.
}
\description{
\code{apply_user_cleanup} applies to each event the manual cleanup based on
data points stored in the RDS file created using \code{user_cleanup_app}. The
Identified datapoints will be changed to NA.
}
\examples{
if (interactive()) {

# Load example data
data("Pupilex4")

# Ensure log file exists by using the cleanup app
# Writing log file to temporary folder for the example
user_cleanup_app(Pupilex4, LogFile = paste0(tempdir(),"/UserCleanupLog.rds"))

# Make cleanup via the app interface

# Read log file from the temporary folder
dat <- apply_user_cleanup(Pupilex4,
                          LogFile = paste0(tempdir(),"/UserCleanupLog.rds"))
}

# Please see the vignettes for detailed example usage.
# vignette("PupilPre_Cleanup", package="PupilPre")

}
