% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PyCall.R
\name{pyCall}
\alias{pyCall}
\title{Call a callable Python object from within R}
\usage{
pyCall(callableObj, args = NULL, kwargs = NULL, autoTypecast = TRUE,
  simplify = TRUE)
}
\arguments{
\item{callableObj}{a character string giving the name of the desired callable
Python object.}

\item{args}{an optional list of arguments passed to the callable.}

\item{kwargs}{an optional list of named arguments passed to the callable.}

\item{autoTypecast}{an optional logical value, default is TRUE, specifying
if the return values should be automatically typecasted if possible.}

\item{simplify}{an optional logical value, if TRUE, R converts Python lists
into R vectors whenever possible, else it translates Python
lists always to R lists.}
}
\value{
Returns the result of the function call, converted into an R object.
}
\description{
Call a callable Python object from within R.
}
\details{
The args and kwargs are transformed to Python variables by the
         default conversion. More information about the type conversion can
         be found in the vignette.
}
\examples{
\dontshow{PythonInR:::pyCranConnect()}
pyCall("sum", args=list(1:3))

## define a new function with the name fun
pyExec('
def fun(**kwargs):
    return([(key, value) for key, value in kwargs.items()])
')
pyCall("fun", kwargs=list(a=1, f=2, x=4))
}

