% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QBAD.R
\name{momQBAD}
\alias{momQBAD}
\title{Method of moments (MoM) estimation for the quantile-based asymmetric family of distributions.}
\usage{
momQBAD(y, f, alpha = NULL)
}
\arguments{
\item{y}{This is a vector of quantiles.}

\item{f}{This is the reference density function \eqn{f} which is a standard version of a unimodal and symmetric around 0 density.}

\item{alpha}{This is the index parameter  \eqn{\alpha}.  If \eqn{\alpha} is unknown, indicate NULL which is default option. In this case, the sample skewness will be used to estimate \eqn{\alpha}. If \eqn{\alpha} is known, then the value of \eqn{\alpha} has to be specified in the function.}
}
\value{
\code{\link{momQBAD}} provides the method of moments estimates of the unknown parameters of the distribution.
}
\description{
Parameter estimation in the quantile-based asymmetric family of densities by using method of moments are discussed in Section 3.1 of Gijbels et al. (2019a).
}
\examples{
# Example 1: Let F be a standard normal cumulative distribution function then
f_N<-function(s){dnorm(s, mean = 0,sd = 1)} # density function of N(0,1)
y=rnorm(100)
momQBAD(y=y,f=f_N,alpha=0.5) # If alpha is known with alpha=0.5
momQBAD(y=y,f=f_N) # If alpha is unknown


# Example 2: Let F be a standard Laplace cumulative distribution function then
f_La<-function(s){0.5*exp(-abs(s))} # density function of Laplace(0,1)
momQBAD(y=y,f=f_La,alpha=0.5) # If alpha is known with alpha=0.5
momQBAD(y=y,f=f_La) # If alpha is unknown
}
\references{
{
 Gijbels, I., Karim, R. and Verhasselt, A. (2019a). On quantile-based asymmetric family of distributions: properties and inference. \emph{International Statistical Review}, \url{https://doi.org/10.1111/insr.12324}.
}
}
