# Copyright (C) 2016 Stanislav Kovalevsky
#
# This file is part of QuantTools.
#
# QuantTools is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# QuantTools is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with QuantTools. If not, see <http://www.gnu.org/licenses/>.

#' c++ Processor class
#' @description c++ class documentation
#' @section Usage: \code{Processor( int timeFrame, double latencySend, double latencyReceive )}
#' @param timeFrame candle timeframe in seconds
#' @param latencySend,latencyReceive latency in seconds
#' @family backtesting classes
#' @family c++ classes
#'
#' @section Public Members and Methods:
#' \tabular{lll}{
#' \cr \strong{Name}                           \tab \strong{Return Type}       \tab \strong{Description}
#' \cr \code{onCandle( \link{Candle} candle )} \tab \code{std::function}       \tab called on new candle event
#' \cr \code{onTick( \link{Tick} tick )}       \tab \code{std::function}       \tab called on new tick event
#' \cr \code{Feed( \link{Tick} tick )}         \tab \code{void}                \tab process by individual tick
#' \cr \code{Feed( Rcpp::DataFrame ticks )}    \tab \code{void}                \tab batch process, see 'Ticks' section
#' \cr \code{SendOrder( \link{Order}* order )} \tab \code{void}                \tab send order to exchange
#' \cr \code{SetCost( \link{Cost} cost )}      \tab \code{void}                \tab set trading costs
#' \cr \code{SetCost( Rcpp::List cost )}       \tab \code{void}                \tab same as above but with R list with columns as in \link{Cost}
#' \cr \code{CancelOrders()}                   \tab \code{void}                \tab cancel active orders
#' \cr \code{GetPosition()}                    \tab \code{int}                 \tab total executed position, positive means long, negative means short
#' \cr \code{GetPositionPlanned()}             \tab \code{int}                 \tab total number of orders processing ( not executed or cancelled yet )
#' \cr \code{GetMarketValue()}                 \tab \code{double}              \tab total portfolio percent value ( initial value is 0 )
#' \cr \code{GetCandles()}                     \tab \code{Rcpp::List}          \tab candles history, see 'Candles' section
#' \cr \code{GetOrders()}                      \tab \code{Rcpp::List}          \tab orders history, see 'Orders' section
#' \cr \code{GetTrades()}                      \tab \code{Rcpp::List}          \tab trades history, see 'Trades' section
#' \cr \code{GetSummary()}                     \tab \code{Rcpp::List}          \tab trades summary, see 'Summary' section
#' \cr \code{GetOnCandleMarketValueHistory()}  \tab \code{std::vector<double>} \tab vector of portfolio value history recalculated on candle complete
#' \cr \code{GetOnCandleDrawDownHistory()}     \tab \code{std::vector<double>} \tab vector of portfolio drawdown history recalculated on candle complete
#' \cr \code{GetOnDayClosePerformanceHistory()}\tab \code{Rcpp::List}          \tab data.table of daily performance history with columns \code{date, return, pnl, drawdown}
#' \cr \code{Reset()}                          \tab \code{void}                \tab resets to initial state
#' \cr \code{SetCost( \link{Cost} cost )}      \tab \code{void}                \tab sets trading commissions cost
#' }
#' @section Execution model:
#' System sends new order and after \code{latencySend} seconds it reaches exchange.
#' System receives confirmation of order placement \code{latencyReceive} seconds later.
#' When execution conditions met on exchange - order is executed and system receives
#' execution confirmation \code{latencyReceive} seconds later.\cr
#' When system sends cancel request to exchange and after \code{latencySend} seconds
#' when exchange receives cancel request if order is not executed yet it is cancelled and
#' cancellation confirmation is received by system after \code{latencyReceive} seconds.
#' @section Ticks:
#' Ticks must be a data.frame/data.table with at least the following columns:
#' \tabular{ll}{
#' \cr \strong{Name} \tab \strong{Description}
#' \cr time          \tab time
#' \cr price         \tab price
#' \cr volume        \tab volume
#' }
#' tick id is ticks row number.
#' @section Candles:
#' Candles returned as data.table with the following columns:
#' \tabular{ll}{
#' \cr \strong{Name} \tab \strong{Description}
#' \cr time          \tab time when formed
#' \cr open          \tab first tick price
#' \cr high          \tab maximum tick price
#' \cr low           \tab minimum tick price
#' \cr close         \tab last tick price
#' \cr volume        \tab total volume traded
#' \cr id            \tab tick id when formed ( first tick after time formed )
#' }
#' @section Orders:
#' Orders returned as data.table with the following columns:
#' \tabular{ll}{
#' \cr \strong{Name}  \tab \strong{Description}
#' \cr id_trade       \tab trade id
#' \cr id_sent        \tab tick id when order was sent to exchange
#' \cr id_processed   \tab tick id when enter order execution or cancelled confirmation was received ( first tick after \code{time_processed} )
#' \cr time_sent      \tab time when order was sent to exchange
#' \cr time_processed \tab time when enter order execution or cancelled confirmation was received
#' \cr price_init     \tab initial price
#' \cr price_exec     \tab execution price
#' \cr side           \tab \code{buy}/\code{sell}
#' \cr type           \tab \code{limit}/\code{market}
#' \cr state          \tab \code{new}/\code{registered}/\code{executed}/\code{cancelling}/\code{cancelled}
#' \cr comment        \tab comment
#' }
#' @section Trades:
#' Two orders are combined into trade by trade id. The first and the second orders are called enter and exit respectively.
#' Trade side is long if enter order is buy and short if enter order is sell
#' Orders must be buy and sell only. Two buys or two sells not allowed. Trade can be \code{new} when order to open trade is just placed, \code{opened} when trade is not closed yet and \code{closed} when trade is flat.
#' Trades returned as data.table with the following columns:
#' \tabular{ll}{
#' \cr \strong{Name} \tab \strong{Description}
#' \cr id_trade      \tab trade id
#' \cr id_sent       \tab tick id when enter order was sent to exchange
#' \cr id_enter      \tab tick id when enter order execution confirmation was received ( first tick after enter \code{time_executed} )
#' \cr id_exit       \tab tick id when exit order execution confirmation was received ( first tick after exit \code{time_executed} )
#' \cr time_sent     \tab time when enter order sent to exchange
#' \cr time_enter    \tab time when enter order execution confirmation was received
#' \cr time_exit     \tab time when exit order execution confirmation was received
#' \cr side          \tab side \code{long}/\code{short}
#' \cr price_enter   \tab enter order execution price
#' \cr price_exit    \tab exit order execution price
#' \cr pnl           \tab trade pnl net
#' \cr mtm_min       \tab min mark-to-market
#' \cr mtm_max       \tab max mark-to-market
#' \cr cost          \tab absolute trading cost
#' \cr pnl_rel       \tab trade pnl net in basis points
#' \cr mtm_min_rel   \tab min mark-to-market in basis points
#' \cr mtm_max_rel   \tab max mark-to-market in basis points
#' \cr cost_rel      \tab relative trading cost in basis points
#' \cr state         \tab \code{new}/\code{opened}/\code{closed}
#' }
#' @section Summary:
#' Back test summary statistics:
#' \tabular{ll}{
#' \cr \strong{Name} \tab \strong{Description}
#' \cr from          \tab first tick time
#' \cr to            \tab last tick time
#' \cr days_tested   \tab number of trading days tested
#' \cr days_traded   \tab number of trading days traded ( at least one order was executed )
#' \cr n_per_day     \tab number of trades per day
#' \cr n             \tab number of trades
#' \cr n_long        \tab number of long trades
#' \cr n_short       \tab number of short trades
#' \cr n_win         \tab number of winning trades
#' \cr n_loss        \tab number of loosing trades
#' \cr pct_win       \tab percent of winning trades
#' \cr pct_loss      \tab percent of loosing trades
#' \cr avg_win       \tab average winning trade in basis points
#' \cr avg_loss      \tab average loosing trade in basis points
#' \cr avg_pnl       \tab average trade pnl in basis points
#' \cr win           \tab total won in percent
#' \cr loss          \tab total lost in percent
#' \cr pnl           \tab total pnl in percent
#' \cr max_dd        \tab maximum drawdown in percent
#' \cr max_dd_start  \tab time the maximum drawdown started
#' \cr max_dd_end    \tab time the maximum drawdown recovered
#' \cr max_dd_length \tab number of calendar days in the maximum drawdown period
#' \cr sharpe        \tab annualized Sharpe ratio calulated on daily returns
#' \cr sortino       \tab annualized Sortino ratio calulated on daily returns
#' \cr r_squared     \tab R Squared calulated on daily PnL values
#' \cr avg_dd        \tab average drawdown calulated on daily drawdown history
#' }
#' @name Processor
#' @rdname cpp_Processor
NULL
