% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0Int_base_stats.R
\name{crossprod_inv}
\alias{crossprod_inv}
\title{Inverse of \eqn{X'X} by QR Decomposition}
\usage{
crossprod_inv(X)
}
\arguments{
\item{X}{\eqn{m*n} matrix}
}
\value{
The inverse \code{'matrix'} of the cross product \eqn{(X'X)}, where \eqn{X} is the input \code{'matrix'}.
}
\description{
Compute \eqn{(X'X)^{-1}} from the R part of the QR decomposition of \eqn{X}.
}
\examples{
set.seed(123); (X = array(rnorm(40L), dim = c(8L, 5L)))
(Xcp = crossprod(X))
all.equal.numeric(solve(Xcp), crossprod_inv(X))


}
\references{
\url{https://en.wikipedia.org/wiki/QR_decomposition}, section \strong{Rectangular matrix}
}
\seealso{
\code{\link[base]{chol2inv}}
}
