% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/QuantumCat.R
\name{QuantumCat}
\alias{QuantumCat}
\title{Data generation}
\usage{
QuantumCat(number_of_clones, number_of_mutations, ploidy = 2, depth = 100,
  number_of_samples = 2, Random_clones = F, contamination = NULL,
  Subclonal.CNA.fraction = NULL)
}
\arguments{
\item{number_of_clones}{The wanted number of observable clones (meaning bearing at least 1 mutation)}

\item{number_of_mutations}{The total observed number of mutations (across all clones)}

\item{ploidy}{The general ploidy of the tumor. Default is 2. If "disomic" : only AB regions will be generated.}

\item{depth}{The depth of sequencing (does not account for contamination). Default is 100x}

\item{number_of_samples}{The number of samples on which the data should be simulated. Default is 2.}

\item{Random_clones}{Should the number of clones be generated randomly (sample(1:10))}

\item{contamination}{A numeric vector indicating the fraction of normal cells in each sample.}

\item{Subclonal.CNA.fraction}{Cell fraction of the subclone that has subclonal CNA}
}
\description{
Creates plausible data as would be oserved by genome sequencing
}
\examples{
print("Generate small set of mutations from 2 differents clones...")
print("...in 1 sample, contaminated at 10\% by normal cells")

QuantumCat(number_of_clones=2,number_of_mutations=50,number_of_samples=1,contamination=0.1)
}
\keyword{Data}
\keyword{generation}
\keyword{phylogeny}

