% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QuantumClone.R
\name{Patient_schrodinger_cellularities}
\alias{Patient_schrodinger_cellularities}
\title{Patient Schrodinger Cellularities}
\usage{
Patient_schrodinger_cellularities(SNV_list, FREEC_list = NULL,
  Genotype_provided = FALSE, contamination, restrict.to.AB = FALSE,
  force.single.copy = FALSE)
}
\arguments{
\item{SNV_list}{A list of dataframes (one for each sample), with as columns : (for the first column of the first sample the name of the sample),
the chromosome "Chr",the position of the mutation "Start", the number of reads supporting the mutation "Alt", the depth of coverage at this locus "Depth",
and if the output from FREEC for the samples are not associated, the genotype "Genotype".}

\item{FREEC_list}{list of dataframes from FREEC for each samples (usually named Sample_ratio.txt), in the same order as SNV_list}

\item{Genotype_provided}{If the FREEC_list is provided, then should be FALSE (default), otherwise TRUE}

\item{contamination}{Numeric vector describind the contamination in all samples (ranging from 0 to 1). Default is 0. 
No longer used for clustering.}

\item{restrict.to.AB}{Should the analysis keep only sites located in A and AB sites in all samples?}

\item{force.single.copy}{Should all mutations in overdiploid regions set to single copy? Default is FALSE}
}
\description{
Computes all possible cellularities for all mutations across all samples. Calls CellularitiesFromFreq on all mutations to evaluate all possibilities
}
\keyword{Clonal}
\keyword{inference}
