% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wald.test.R
\name{Wald.test}
\alias{Wald.test}
\title{the Wald test for two q-vectors}
\usage{
Wald.test(CDM.obj, q1, q2, i = 1)
}
\arguments{
\item{CDM.obj}{An object of class \code{CDM.obj}. @seealso \code{\link[Qval]{CDM}}.}

\item{q1}{A q-vector}

\item{q2}{Another q-vector}

\item{i}{the item needed to be validated}
}
\value{
An object of class \code{htest} containing the following components:
\describe{
 \item{statistic}{The statistic of the Wald test.}
 \item{parameter}{the degrees of freedom for the Wald-statistic.}
 \item{p.value}{The p value}
}
}
\description{
This function flexibly provides the Wald test for any two q-vectors of a given item in the Q-matrix, 
but requires that the two q-vectors differ by only one attribute. Additionally, this function needs 
to accept a \code{CDM.obj}.
}
\details{
\deqn{
   Wald = \left[\mathbf{R} \times P_{i}(\mathbf{\alpha})\right]^{'}
   (\mathbf{R} \times \mathbf{V}_{i} \times \mathbf{R})^{-1}
   \left[\mathbf{R} \times P_{i}(\mathbf{\alpha})\right]
}
}
\examples{
library(Qval)
set.seed(123)

K <- 3
I <- 20
N <- 500
IQ <- list(
  P0 = runif(I, 0.0, 0.2),
  P1 = runif(I, 0.8, 1.0)
)
Q <- sim.Q(K, I)
data <- sim.data(Q = Q, N = N, IQ = IQ, model = "GDINA", distribute = "horder")

CDM.obj <- CDM(data$dat, Q)

q1 <- c(1, 0, 0)
q2 <- c(1, 1, 0)

## Discuss whether there is a significant difference when 
## the q-vector of the 2nd item in the Q-matrix is q1 or q2.
Wald.test.obj <- Wald.test(CDM.obj, q1, q2, i=2)

print(Wald.test.obj)


}
