% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twosample_power.R
\name{twosample_power}
\alias{twosample_power}
\title{twosample_power}
\usage{
twosample_power(
  f,
  ...,
  alpha = 0.05,
  B = 1000,
  nbins = c(100, 10),
  maxProcessor = 10,
  doMethod = "all"
)
}
\arguments{
\item{f}{function to generate a list with data sets x, y and (optional) vals}

\item{...}{additional arguments passed to f}

\item{alpha}{=0.05, the level of the hypothesis test}

\item{B}{=1000, number of simulation runs for permutation test and power.}

\item{nbins}{=c(100,10), number of bins for chi large and chi small.}

\item{maxProcessor}{=10, maximum number of cores to use. If maxProcessor=1 no parallel computing is used.}

\item{doMethod}{="all", which methods should be included?}
}
\value{
A numeric vector of power values.
}
\description{
Find the power of various two sample tests using Rcpp and parallel computing.
}
\examples{
 f=function(mu) list(x=rnorm(25), y=rnorm(25, mu))
 twosample_power(f, mu=c(0,2), B=100, maxProcessor = 1)
 f=function() list(x=table(sample(1:10, size=1000, replace=TRUE)), 
       y=table(sample(1:10, size=1200, replace=TRUE)), vals=1:10)
 twosample_power(f, B=100, maxProcessor = 1)
}
