% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_plot.r
\name{html_plot}
\alias{html_plot}
\title{Prints a R plot to a HTML file or console}
\usage{
html_plot(plot, out, title = "plot", titlepr = NULL, footnote = "",
  pwidth = 1000, pheight = 600, res = NULL, fontsize = 12,
  units = "px", rawout = paste0(out, ".rawhtml"), ...)
}
\arguments{
\item{plot}{plot object or function call that creates plot to be printed to file}

\item{out}{filename for the output HTML file}

\item{title}{character string to define the title of the table which will be added to the caption}

\item{titlepr}{character string to define the prefix of the table title. Can be used to create custom table numbering}

\item{footnote}{character string with the footnote to be placed in the footer of the page (HTML coding can be used for example to create line breaks)}

\item{pwidth}{numeric indicating the width of the plot to be generated in pixels}

\item{pheight}{numeric indicating the height of the plot to be generated in pixels}

\item{res}{numeric indicating the resolution of the plot, if set to NULL it will adapt the value according height of the plot}

\item{fontsize}{character string with the default font or pointsize passed through to png function}

\item{units}{character string with the units to use for plot width and height passed through to png function}

\item{rawout}{character string with the name of the raw HTML file to generate (e.g. only plotting code)
In case NULL no raw output will be generated. In order to combine results the filename should end in .raw.html}

\item{...}{additional arguments passed through to \code{\link{html_doc}}. Most important are template, rendlist, css and show}
}
\value{
The function returns a HTML file (or writes output to console)
}
\description{
This function makes a HTML document including the defined plots
}
\examples{

# It is convenient to have an object for the plot argument
\dontrun{

  data(Theoph)
  library(ggplo2)
  pl <- qplot(Time, conc, data=Theoph, facets=~Subject,geom="line")
  html_plot(pl,out=paste0(tempfile(),".html"))

  # Base plots work a bit different and can be placed
  # in the function directly or wrapped in a function
  html_plot(plot(conc~Time,data=Theoph),out=tempfile(fileext=".html"))
  pl <- function() {
    plot(conc~Time,data=Theoph)
    title(main="a plot")
  }
  html_plot(pl(),out=tempfile(fileext=".html"))
}
}
