% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_comparison_Power_vs_Trt.R
\name{power_comparison_Power_vs_Trt}
\alias{power_comparison_Power_vs_Trt}
\title{Comparison of Powers for Treatment Effects under Different DBCD Randomization
Methods (Binary Responses)}
\usage{
power_comparison_Power_vs_Trt(n, nstart, p_pbo, p_trt, nstop,
replication, group_allo, rho_func_index, rho_func, alpha, sig_level)
}
\arguments{
\item{n}{The number of patients. The default is 100.}

\item{nstart}{Burn-in sample size of each arm. The default is n/20.}

\item{p_pbo}{Success rate of placebo (control) arm. The default is 0.3.}

\item{p_trt}{A vector containing success rates of treatment arm.}

\item{nstop}{A vector of stopping cap of sample size for each arm. The trial
stops if at least one arm reaches the corresponding cap.
The default is NULL, which means no cap.}

\item{replication}{the number of replications of the simulation. The default
is 100.}

\item{group_allo}{A number or a vector of group size(s) for allocation.
If a number is given, the allocation ratios will be updated for each batch of
 group_allo samples. If a vector is given, the allocation ratios will be
 updated sequentially in group according to the vector.
 Any value greater than n will be omitted.
The default is group_allo=1, which is the same as group_allo = seq(nstart*length(p)+1,n).}

\item{rho_func_index}{Supply a number of 1, 2 or 3 indicting the
allocation function to use.
1 = Wei's allocation
2 = Neyman allocation;
3 (default) = Rosenberger allocation;}

\item{rho_func}{Supply a user-specified allocation function of Mean_RK and
SD_RK when rho_func_index is NULL. Default is NULL.}

\item{alpha}{Supply a number indicating the subscripts of the probability
function. The default is 2.}

\item{sig_level}{Significant level. The default is 0.05.}
}
\value{
\itemize{
  \item Allocation - Average and standard deviation (SD) of allocation distribution
  \item Estimation - Average and standard deviation of treatment effect
  \item Power - Average power: 1) Chi-square test, 2) one-sided proportion test performed for each of the k-th arm against H0: p_1>p_k without multiplicity adjustment
  \item Plot - Three figures of results: 1) Allocation mean and SD, 2) Estimated mean response and SD, 3) Power of Chi-square test and power of one-sided proportion test
}
}
\description{
Compares the power of a 2-arm design under different treatment effects
for the same sample size and placebo effect through matrices and plots.
}
\details{
'power_comparison_Power_vs_Trt' reads different treatment effects
and outputs allocation, estimated rates and powers.
}
\examples{
## Default setting
power_comparison_Power_vs_Trt(
n = 100,
nstart = round(100/20),
p_pbo = 0.3,
p_trt = seq(0,0.3,0.1)+0.3,
nstop = NULL,
replication = 5,
group_allo = 1,
rho_func_index = 3,
rho_func = NULL,
alpha = 2,
sig_level = 0.05
)


}
