% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addProvenance.R
\name{addProvenance}
\alias{addProvenance}
\title{Add provenance information to a cmip5data object}
\usage{
addProvenance(x, msg, verbose = FALSE)
}
\arguments{
\item{x}{A \code{\link{cmip5data}} object}

\item{msg}{Either a string (message to be added to the provenance) or
a cmip5data object, in which case the provenance of this latter object is appended
to that of \code{x} (i.e., their histories are merged)}

\item{verbose}{logical. Print info as we go?}
}
\value{
The original object, with an updated provenance containing:
 \item{timestamp}{Date and time entry was added}
 \item{caller}{The function that added this entry, including its parameter values}
 \item{message}{Description of action(s) taken}
 \item{dim}{Data dimensions when this entry was added}
 \item{digest}{Hash of the data when this entry was added; see \code{\link{digest}}}
}
\description{
It's important to track data provenance, the steps taken to produce a particular
dataset. Each operation in the RCMIP5 package adds provenance information via this function.
}
\details{
We want to track computational steps applied to a particular
\code{\link{cmip5data}} object, for reproducibility and user debugging.
This function logs information from the caller to a 'provenance' data structure.
}
\note{
This is an internal RCMIP5 function and not exported.
}
\keyword{internal}

