% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.functions.r
\name{wtd.sd}
\alias{wtd.sd}
\title{Calculates Standard Deviation of Variable With Option for Weights}
\usage{
wtd.sd(x, w = NULL, data, digits = 3, ...)
}
\arguments{
\item{x}{A variable (must be numeric), should be in dataset$var form unless dataset specified in optional data argument.}

\item{w}{(Optional) Sampling weights of variable, must be numeric; should be in dataset$weightvar form unless dataset specified in optional data argument.}

\item{data}{(Optional) Name of dataset that contains x (and w) variable.}

\item{digits}{(Optional) Number of decimal places reported in result (defaults to 3).}

\item{...}{(Optional) Additional arguments passed to Hmisc::wtd.var function.}
}
\value{
Returns the standard deviation of the variable, a numeric value.
}
\description{
Takes in variable and calculates standard deviation, works with sampling weights. Makes use of the wtd.var function, part of the Hmisc package.
}
\examples{
   library(RCPA3)
   
   wtd.sd(x=nes$ft.socialists, w=nes$wt)
   wtd.sd(x=nes$ft.socialists)
}
\keyword{internal}
