% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetFormStructure.R
\name{GetFormStructure}
\alias{GetFormStructure}
\title{Get the form structure of a form.}
\usage{
GetFormStructure(token, idForm, nameForm = NULL, componentId = NULL)
}
\arguments{
\item{token}{A string access token.}

\item{idForm}{Numeric Id of the required form.}

\item{nameForm}{String name of the required form. Just is used when an idForm
are not supplied. When this parameter is used, are spent extra one access
quota.}

\item{componentId}{Optional filter. That is the field identifier, it's
possible use to filter to get a specific field.}
}
\value{
A possible nested data frame.
}
\description{
Get the structure of the questions of a specific form in the shape a nested
data frame, that contains all the needed information to request the answers
of the form.
}
\details{
To get more details about the fields provided by the result, please visit the
\href{https://coletum.docs.apiary.io/#reference/0/formularios/definicao-de-formulario}{API documentation}.
}
\examples{
\donttest{
GetFormStructure("cizio7xeohwgc8k4g4koo008kkoocwg", 5705)
GetFormStructure("cizio7xeohwgc8k4g4koo008kkoocwg", , "RColetum Test - Iris")
GetFormStructure(token = "cizio7xeohwgc8k4g4koo008kkoocwg",
                nameForm = "RColetum Test - Iris")
}
}
