% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersectConicConic.R
\name{intersectConicConic}
\alias{intersectConicConic}
\title{Intersection between two conics}
\source{
Richter-Gebert, Jürgen (2011). 
\emph{Perspectives on Projective Geometry - A Guided Tour Through Real
and Complex Geometry}, Springer, Berlin, ISBN: 978-3-642-17285-4
}
\usage{
intersectConicConic(C1, C2)
}
\arguments{
\item{C1}{\eqn{(3 \times 3)} matrix representation of conics.}

\item{C2}{\eqn{(3 \times 3)} matrix representation of conics.}
}
\value{
The homogeneous coordinates of the intersection points. 
If there are \eqn{k} points of intersection, it returns a \eqn{(3 \times k)} 
matrix whose columns correspond to the homogeneous coordinates of the intersection points. 
If there is only one point, a \eqn{(3 \times 1)} vector of the homogeneous 
coordinates of the intersection point is returned. 
If there is no intersection, \code{NULL} is returned.
}
\description{
Returns the point(s) of intersection between two conics in homogeneous coordinates.
}
\examples{
# Ellipse with semi-axes a=8, b=2, centered in (0,0), with orientation angle = -pi/3
C1 <- ellipseToConicMatrix(c(8,2), c(0,0), -pi/3)

# Ellipse with semi-axes a=5, b=2, centered in (1,-2), with orientation angle = pi/5
C2 <- ellipseToConicMatrix(c(5,2), c(1,-2), pi/5)

# intersection conic C with conic C2
p_CC2 <- intersectConicConic(C1,C2)

# plot
plot(ellipse(c(8,2), c(0,0), -pi/3),type="l",asp=1)
lines(ellipse(c(5,2), c(1,-2), pi/5), col="blue")
points(t(p_CC2), pch=20,col="blue")
}
