#' @title Get Download Url
#' 
#' @description This function returns the download Url of the report.
#' 
#' @param authToken Authentication token generated by \code{\link{doCriteoAuth}}
#' @param appToken Application Token
#' @param jobID jobID generated by \code{\link{scedCriteoReport}}
#' 
#' @export
#' 
#' @return Download URL
getCriteoDownloadURL <- function(authToken, appToken, jobID){
  body = paste('<?xml version="1.0" encoding="utf-8"?>
                              <soap:Envelope xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
               <soap:Header>
               <apiHeader xmlns="https://advertising.criteo.com/API/v201010">
               <authToken>', authToken ,'</authToken>
               <appToken>', appToken ,'</appToken>
               <clientVersion>3.6</clientVersion>
               </apiHeader>
               </soap:Header>
               <soap:Body>
               <getReportDownloadUrl xmlns="https://advertising.criteo.com/API/v201010">
               <jobID>', jobID ,'</jobID>
               </getReportDownloadUrl>
               </soap:Body>
               </soap:Envelope>', sep="")
                  
                  headerFields = c(Accept = "text/xml",
                                   Accept = "multipart/*",
                                   'Content-Type' = "text/xml; charset=utf-8",
                                   SOAPAction = "https://advertising.criteo.com/API/v201010/getReportDownloadUrl")
                  
                  h = RCurl::basicTextGatherer()
                  
                  RCurl::curlPerform(url = "https://advertising.criteo.com/API/v201010/AdvertiserService.asmx",
                              httpheader = headerFields,
                              postfields = body,
                              writefunction = h$update
                  )
                  
                  data <- XML::xmlParse(h$value())
                  data <- XML::xmlToList(data)
                  
                  data$Body$getReportDownloadUrlResponse$jobURL
}