% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constant.R
\name{constant}
\alias{constant}
\alias{constant_to_form_completion}
\alias{constant_to_form_rights}
\alias{constant_to_export_rights}
\alias{constant_to_access}
\title{Collection of REDCap-specific constants}
\usage{
constant(name, simplify = TRUE)
}
\arguments{
\item{name}{Name of constant.  Required character.}

\item{simplify}{Simplifies the vector of values to a common data-type, if possible.
Passed to the \code{simplify} parameter of \code{\link[base:sapply]{base::sapply()}}.}
}
\value{
The constant's value.  Currently all are single integers,
but that could be expanded in the future.
}
\description{
Collection of constants defined by the REDCap developers.
}
\details{
\strong{Form Completeness}

The current constants relate to the 'complete' variable at the end of each form.
\itemize{
\item \code{form_incomplete}: 0L (\emph{i.e.}, an integer)
\item \code{form_unverified}: 1L
\item \code{form_complete}: 2L
}

\strong{Export Rights}

See https://your-server/redcap/api/help/?content=exp_users.
\itemize{
\item \code{data_export_rights_no_access}    : 0L
\item \code{data_export_rights_deidentified} : 1L
\item \code{data_export_rights_full}         : 2L
}

\strong{Form Rights}

See https://your-server/redcap/api/help/?content=exp_users.
The order of these digits may be unexpected.
\itemize{
\item \code{form_rights_no_access}    : 0L
\item \code{form_rights_readonly}     : 2L
\item \code{form_rights_edit_form}    : 1L
\item \code{form_rights_edit_survey}  : 3L
}

\strong{Access Rights}

See https://your-server/redcap/api/help/?content=exp_users.
\itemize{
\item \code{access_no}    : 0L
\item \code{access_yes}   : 1L
}

To add more, please for and edit
\href{https://github.com/OuhscBbmc/REDCapR/blob/master/R/constant.R}{constant.R}
on GitHub and submit a pull request.  For instructions, please see
\href{https://help.github.com/articles/editing-files-in-another-user-s-repository/}{Editing files in another user's repository}
in the GitHub documentation.
}
\examples{
REDCapR::constant("form_incomplete")  # Returns 0L
REDCapR::constant("form_unverified")  # Returns 1L
REDCapR::constant("form_complete"  )  # Returns 2L

REDCapR::constant("data_export_rights_no_access"   )  # Returns 0L
REDCapR::constant("data_export_rights_deidentified")  # Returns 1L
REDCapR::constant("data_export_rights_full"        )  # Returns 2L

REDCapR::constant("form_rights_no_access")     # Returns 0L
REDCapR::constant("form_rights_readonly" )     # Returns 2L --Notice the order
REDCapR::constant("form_rights_edit_form")     # Returns 1L
REDCapR::constant("form_rights_edit_survey")   # Returns 3L

REDCapR::constant("access_no" )  # Returns 0L
REDCapR::constant("access_yes")  # Returns 1L

REDCapR::constant(c("form_complete", "form_complete", "form_incomplete")) # Returns c(2L, 2L, 0L)
REDCapR::constant(c(
  "form_rights_no_access",
  "form_rights_readonly",
  "form_rights_edit_form",
  "form_rights_edit_survey"
)) # Returns c(0L, 2L, 1L, 3L)


constant_to_form_completion( c(0, 2, 1, 2, NA))
constant_to_form_rights(     c(0, 2, 1, 2, NA))
constant_to_export_rights(   c(0, 2, 1, 3, NA))
constant_to_access(          c(0, 1, 1, 0, NA))

\dontrun{
# The following line returns an error:
#     Assertion on 'name' failed: Must be a subset of
#     {'form_complete','form_incomplete','form_unverified'},
#     but is {'bad-name'}.

REDCapR::constant("bad-name")    # Returns an error

REDCapR::constant(c("form_complete", "bad-name")) # Returns an error
}
}
\author{
Will Beasley
}
