% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rforcecom.checkBatchStatus.R
\name{rforcecom.checkBatchStatus}
\alias{rforcecom.checkBatchStatus}
\title{Checking the Status of a Batch in a Bulk API Job}
\usage{
rforcecom.checkBatchStatus(session, jobId, batchId)
}
\arguments{
\item{session}{a named character vector defining parameters of the api connection as returned by \link{rforcecom.login}}

\item{jobId}{a character string defining the salesforce id assigned to a submitted job as returned by \link{rforcecom.createBulkJob}}

\item{batchId}{a character string defining the salesforce id assigned to a submitted batch as returned by \link{rforcecom.createBulkBatch}}
}
\value{
A \code{list} of parameters defining the batch identified by the batchId
}
\description{
This function checks on and returns status information on an existing batch
which has already been submitted to Bulk API Job
}
\examples{
\dontrun{
batch_status <- rforcecom.checkBatchStatus(session, jobId=job_info$id, batchId=batches_info[[1]]$id)
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
\concept{
bulk batch salesforce api
}

