/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.transformer;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractSingleObjectiveFitnessFunction;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.FitnessTransformer;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;

public class AffineTransformer
extends AbstractSingleObjectiveFitnessFunction
implements FitnessTransformer,
Configurable {
    private FitnessFunction delegate;
    private double a = 1.0;
    private double b = 0.0;

    public AffineTransformer(Schedule schedule) {
        super(schedule);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (this.getFitnessFunction() == null ? !(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction) : !(this.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
    }

    public String getDescription() {
        return "This transformer modifies the fitness value according to the formula f'=a*f+b";
    }

    public String getName() {
        return "AffineTransformer";
    }

    public void setFitnessFunction(FitnessFunction fitness) {
        this.delegate = fitness;
    }

    public FitnessFunction getFitnessFunction() {
        return this.delegate;
    }

    public Double getPropertyA() {
        return new Double(this.a);
    }

    public void setPropertyA(Double a) {
        this.a = a;
    }

    public Double getPropertyB() {
        return new Double(this.b);
    }

    public void setPropertyB(Double b) {
        this.b = b;
    }

    public double evaluate(Individual individual, IndividualList list) {
        double temp = ((SingleObjectiveFitnessFunction)this.delegate).evaluate(individual, list);
        return this.a * temp + this.b;
    }

    public double getOptimalFitnessValue() throws UnsupportedOperationException {
        if (this.a < 0.0) {
            throw new UnsupportedOperationException();
        }
        return this.a * ((SingleObjectiveFitnessFunction)this.delegate).getOptimalFitnessValue() + this.b;
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        if (this.a <= 0.0) {
            throw new UnsupportedOperationException();
        }
        return this.delegate.getPhenotypeOptimum();
    }

    public double getLowerBound() throws UnsupportedOperationException {
        return this.a < 0.0 ? this.a * ((SingleObjectiveFitnessFunction)this.delegate).getUpperBound() + this.b : this.a * ((SingleObjectiveFitnessFunction)this.delegate).getLowerBound() + this.b;
    }

    public double getUpperBound() throws UnsupportedOperationException {
        return this.a > 0.0 ? this.a * ((SingleObjectiveFitnessFunction)this.delegate).getUpperBound() + this.b : this.a * ((SingleObjectiveFitnessFunction)this.delegate).getLowerBound() + this.b;
    }
}

