/*
 * Decompiled with CFR 0.152.
 */
package freak.module.stoppingcriterion;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.GenerationEvent;
import freak.core.event.GenerationEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.searchspace.HasDimension;
import freak.core.stoppingcriterion.AbstractStoppingCriterion;

public class AdditiveGenerationCount
extends AbstractStoppingCriterion
implements Configurable,
GenerationEventListener {
    private int basecount = 5000;
    private int add;

    public AdditiveGenerationCount(Schedule schedule) {
        super(schedule);
        if (schedule.getGenotypeSearchSpace() instanceof HasDimension) {
            int dim = ((HasDimension)((Object)schedule.getGenotypeSearchSpace())).getDimension();
            this.basecount = (int)Math.round((double)dim * (Math.log(dim) / Math.log(2.0)));
        }
        this.add = this.basecount;
    }

    public String getName() {
        return "Additive Generation Count";
    }

    public String getDescription() {
        return "Stops a run after \"basecount + (runnumber - 1) * addcount\" number of generations.";
    }

    public void setPropertyBaseCount(Integer count) {
        if (count > 0) {
            this.basecount = count;
        }
    }

    public Integer getPropertyBaseCount() {
        return new Integer(this.basecount);
    }

    public String getShortDescriptionForBaseCount() {
        return "Base count";
    }

    public String getLongDescriptionForBaseCount() {
        return "The base number of generations after a run will be stopped. The exact number of generations after the first run will be stopped.";
    }

    public void setPropertyAddCount(Integer count) {
        this.add = count;
    }

    public Integer getPropertyAddCount() {
        return new Integer(this.add);
    }

    public String getShortDescriptionForAddCount() {
        return "Add count";
    }

    public String getLongDescriptionForAddCount() {
        return "Each next run has this addition count of generations over than the run before.";
    }

    public void generation(GenerationEvent evt) {
        if (evt.getNumber() >= this.basecount + (this.getSchedule().getCurrentRun() - 1) * this.add) {
            this.stopRun();
        }
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, GenerationEvent.class, this.schedule);
    }
}

