/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.EventListener;
import freak.core.event.GenerationEvent;
import freak.core.event.GenerationEventListener;
import freak.core.observer.AbstractObserver;

public class Benchmark
extends AbstractObserver
implements GenerationEventListener {
    private long first = 0L;
    private long gens = 0L;

    public Benchmark(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public String getName() {
        return "Benchmark";
    }

    public String getDescription() {
        return "Computes the number of generations per second.";
    }

    public Class getOutputDataType() {
        return String.class;
    }

    public void createEvents() {
        this.schedule.getEventController().addEvent((EventListener)this, GenerationEvent.class, this.schedule);
    }

    public void generation(GenerationEvent evt) {
        long now = System.currentTimeMillis();
        if (this.first == 0L) {
            this.first = now;
        } else {
            ++this.gens;
            long t = now - this.first;
            if (t >= 1000L) {
                double gps = (double)(1000L * this.gens) / (double)t;
                String s = gps > 10.0 ? String.valueOf(Math.round(gps)) + " generations per second" : String.valueOf(Math.rint(gps * 100.0) / 100.0) + " generations per second";
                this.updateViews(s);
                this.first = now;
                this.gens = 0L;
            }
        }
    }
}

