/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.crossover.cycle;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.control.Schedule;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Recombination;
import freak.core.modulesupport.Configurable;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;
import freak.module.searchspace.PermutationGenotype;
import java.util.Iterator;

public class InverOver
extends Recombination
implements Configurable {
    private double p = 0.02;

    public InverOver(OperatorGraph graph) {
        super(graph);
        super.addInPort();
        super.addOutPort();
    }

    public void setPropertyProbNewConnections(Double prob) {
        if (prob >= 0.0 && prob <= 1.0) {
            this.p = prob;
        }
    }

    public Double getPropertyProbNewConnections() {
        return new Double(this.p);
    }

    public String getShortDescriptionForProbNewConnections() {
        return "New connections' probability";
    }

    public String getLongDescriptionForProbNewConnections() {
        return "Probability to create new connections.";
    }

    private int findIndex(int[] tour, int city) {
        int i = 0;
        while (tour[i] != city) {
            ++i;
        }
        return i;
    }

    public IndividualList[] process(IndividualList[] input) {
        Schedule schedule = this.graph.getSchedule();
        RandomElement re = schedule.getRandomElement();
        IndividualList population = input[0];
        Iterator it = population.iterator();
        int input0size = input[0].size();
        IndividualList[] output = new IndividualList[]{new Population(schedule, input0size)};
        while (it.hasNext()) {
            Individual parent = (Individual)it.next();
            int[] tour = ((PermutationGenotype)parent.getGenotype()).getIntArray();
            int indexOfCity = re.choose(0, tour.length - 1);
            int city = tour[indexOfCity];
            boolean exitloop = false;
            do {
                int indexPCity;
                int nextCity;
                int indexOfNextCity;
                if (re.raw() <= this.p) {
                    indexOfNextCity = re.choose(0, tour.length - 2);
                    if (indexOfCity == indexOfNextCity) {
                        indexOfNextCity = tour.length - 1;
                    }
                    nextCity = tour[indexOfNextCity];
                } else {
                    int[] tour2 = ((PermutationGenotype)population.getIndividual(re.choose(0, input0size - 1)).getGenotype()).getIntArray();
                    nextCity = tour2[(this.findIndex(tour2, city) + 1) % tour2.length];
                    indexOfNextCity = -1;
                }
                int indexNCity = (indexOfCity + 1) % tour.length;
                int n = indexPCity = indexOfCity == 0 ? tour.length - 1 : indexOfCity - 1;
                if (tour[indexNCity] == nextCity || tour[indexPCity] == nextCity) {
                    exitloop = true;
                    continue;
                }
                tour = this.inverse(tour, indexNCity, indexOfNextCity == -1 ? this.findIndex(tour, nextCity) : indexOfNextCity);
            } while (!exitloop);
            Individual child = new Individual(schedule, new PermutationGenotype(tour), new Individual[]{parent});
            output[0].addIndividual(child);
        }
        return output;
    }

    private int[] inverse(int[] tour, int start, int end) {
        int[] result = (int[])tour.clone();
        int i = 0;
        while ((start + i - 1) % tour.length != end) {
            result[(start + i) % tour.length] = tour[end - i < 0 ? end - i + tour.length : end - i];
            ++i;
        }
        return result;
    }

    public String getName() {
        return "Inver-Over";
    }

    public String getDescription() {
        return "Inver-Over is a well known operator for the TSP.";
    }
}

