% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/senCloudMask.R
\name{senCloudMask}
\alias{senCloudMask}
\title{Create cloud masks for Sentinel-2 images}
\usage{
senCloudMask(src, AppRoot, img.res, sensitivity = 50,
  overwrite = FALSE, ...)
}
\arguments{
\item{src}{the path to the folder with the "\code{S2MSI2A}" images.}

\item{AppRoot}{the directory where the cloud masks are saved.}

\item{img.res}{a \code{character} vector argument. Defines the band resolution
used to create the cloud mask. Ex "20m" or "30m".}

\item{sensitivity}{a \code{numeric} argument. Defines the sensitivity of the
cloud detection method.}

\item{overwrite}{logical argument. If \code{TRUE}, overwrites the existing
images with the same name.}

\item{...}{arguments for nested functions.}
}
\description{
\code{senCloudMask} creates cloud masks derived from the cloud probability
band (\code{CLDPROB}) band from the "\code{S2MSI2A}" product.
}
\details{
The valid threshold range for \code{sensitivity} is 0-100. By default,
the argument is set to 50.
}
\examples{
\dontrun{
# load a spatial polygon object of Navarre
data(ex.navarre)
# Download S2MSI1C products sensed by Sentinel-2 
# between the julian days 210 and 218, 2018
src <- paste0(tempdir(),"/Path_for_downloading_folder")
print(src)
senDownload(startDate = as.Date("2018210", "\%Y\%j"),
            endDate = as.Date("2018218", "\%Y\%j"),
            platform = "Sentinel-2",
            extent = ex.navarre,
            product = "S2MSI2A",
            pathrow = c("R094"),
            username = "username",
            password = "password",
            AppRoot = src)
# define the paths to the Sentinle-2 images and the
# folder with the unzipped images
src.sen2 <- file.path(src, "Sentinel-2")
src.unzip <- file.path(src.sen2, "unzip")
# mosaic the Sentinel-2 images
senMosaic(src.unzip,
          AppRoot = src.sen2,
          gutils = TRUE,
          out.name = "Navarre")
          
# calculate the cloud mask
src.navarre <- file.path(src.sen2, "Navarre")
senCloudMask(src = src.navarre,
             img.res = "60m",
             overwrite = TRUE,
             sensitivity = 98,
             AppRoot = src.sen2)
             
# define the path for the Sentinel-2 cloud mask
src.cloud <- file.path(src.sen2, "CloudMask")

# select B02 images of 60 meters
tiles.navarre <- list.files(src.navarre,
                            full.names = TRUE,
                            recursive = TRUE,
                           pattern = "\\\\.tif$")
b2.tiles <- tiles.navarre[grepl("B02",tiles.navarre)]
b2.tiles <- b2.tiles[grepl("60m",b2.tiles)]

# generate a 60-meter resolution cloud mask 
cloud.tiles <- list.files(src.cloud,
                          full.names = TRUE,
                          pattern = "\\\\.tif$")
cloud.tiles <- cloud.tiles[grepl("60m",cloud.tiles)]

# remove the cloud mask from b02 tiles
b2.tiles.stack <- stack(b2.tiles)
cloud.tiles.stack <- stack(cloud.tiles)
b2.cloud.free <- b2.tiles.stack*cloud.tiles.stack
# plot b2 cloud free layers
spplot(b2.cloud.free)
}
}
