/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.stats;

import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.dstats.Chi2;
import ec.tstoolkit.dstats.Normal;
import ec.tstoolkit.dstats.TestType;
import ec.tstoolkit.stats.RunsTestKind;
import ec.tstoolkit.stats.StatisticalTest;

public class TestofRuns
extends StatisticalTest {
    DescriptiveStatistics stats;
    private boolean m_bMean = true;
    private double m_ref;
    private int m_p;
    private int m_m;
    private int m_r;
    private int[] m_nr;
    private RunsTestKind m_kind = RunsTestKind.Number;
    private double[] m_wnc;

    public RunsTestKind getKind() {
        return this.m_kind;
    }

    public int getMCount() {
        return this.m_m;
    }

    public int getPCount() {
        return this.m_p;
    }

    public boolean isUseMean() {
        return this.m_bMean;
    }

    @Override
    public boolean isValid() {
        return this.stats != null && this.stats.getObservationsCount() > 10;
    }

    private void prepare() {
        this.m_p = 0;
        this.m_m = 0;
        this.m_r = 0;
        this.m_ref = this.m_bMean ? this.stats.getAverage() : this.stats.getMedian();
        this.m_wnc = this.stats.observations();
        this.m_nr = new int[this.m_wnc.length];
    }

    private void races() {
        boolean prev;
        int n = this.m_wnc.length;
        if (n == 0) {
            return;
        }
        boolean bl = prev = this.m_wnc[0] >= this.m_ref;
        if (prev) {
            ++this.m_p;
        } else {
            ++this.m_m;
        }
        this.m_r = 1;
        int curlength = 1;
        for (int i = 1; i < n; ++i) {
            boolean cur;
            boolean bl2 = cur = this.m_wnc[i] >= this.m_ref;
            if (cur) {
                ++this.m_p;
            } else {
                ++this.m_m;
            }
            if (cur != prev) {
                ++this.m_r;
                prev = cur;
                int n2 = curlength - 1;
                this.m_nr[n2] = this.m_nr[n2] + 1;
                curlength = 1;
                continue;
            }
            ++curlength;
        }
        int n3 = curlength - 1;
        this.m_nr[n3] = this.m_nr[n3] + 1;
    }

    public int runsCount(int length) {
        return length <= 0 ? this.m_r : this.m_nr[length - 1];
    }

    public void setKind(RunsTestKind value) {
        if (this.m_kind != value) {
            this.m_kind = value;
            this.updateResults();
        }
    }

    public void setUseMean(boolean value) {
        if (this.m_bMean != value) {
            this.m_bMean = value;
            this.test();
        }
    }

    private void test() {
        this.prepare();
        this.races();
        this.updateResults();
    }

    public void test(DescriptiveStatistics stats) {
        this.stats = stats;
        this.test();
    }

    public void test(IReadDataBlock data) {
        this.stats = new DescriptiveStatistics(data);
        this.test();
    }

    private void testLength() {
        int n = this.m_wnc.length;
        double x = 0.0;
        double p = this.m_p;
        double m = this.m_m;
        double fp = p / (double)n;
        double fm = m / (double)n;
        double e = (double)n / (p / m + m / p);
        double xp = fm;
        double xm = fp;
        for (int i = 0; i < n; ++i) {
            double ei = e * ((xp *= fp) + (xm *= fm));
            if (this.m_nr[i] == 0) {
                x += ei;
                continue;
            }
            if (ei != 0.0) {
                x += ((double)this.m_nr[i] - ei) / ei * ((double)this.m_nr[i] - ei);
                continue;
            }
            x += 999999.0;
        }
        Chi2 dist = new Chi2();
        dist.setDegreesofFreedom(n);
        this.m_dist = dist;
        this.m_val = x;
        this.m_type = TestType.Upper;
        this.m_asympt = true;
    }

    private void testNumber() {
        double n = this.m_wnc.length;
        double mp = this.m_m * this.m_p;
        double E = 1.0 + 2.0 * mp / n;
        double V = 2.0 * mp * (2.0 * mp - n) / (n * n * (n - 1.0));
        if (V < 1.0E-9) {
            V = 1.0E-9;
        }
        Normal dist = new Normal();
        this.m_dist = dist;
        this.m_val = ((double)this.m_r - E) / Math.sqrt(V);
        this.m_type = TestType.TwoSided;
        this.m_asympt = true;
    }

    private void updateResults() {
        if (this.m_kind == RunsTestKind.Number) {
            this.testNumber();
        } else {
            this.testLength();
        }
    }
}

