/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.timeseries.simplets;

import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.Enumeration;

public class PeriodIterator
implements Enumeration<TsDataBlock> {
    private final TsDataBlock data_;
    private TsDataBlock cur_;

    public static PeriodIterator fullYears(TsData series) {
        TsDomain domain = series.getDomain();
        int ifreq = domain.getFrequency().intValue();
        int nbeg = series.getStart().getPosition();
        int nend = series.getEnd().getPosition();
        domain = domain.drop(nbeg == 0 ? 0 : ifreq - nbeg, nend);
        return new PeriodIterator(series, domain);
    }

    public PeriodIterator(TsData series) {
        this.data_ = !series.isEmpty() ? TsDataBlock.all(series) : null;
    }

    public PeriodIterator(TsData series, TsDomain domain) {
        this.data_ = TsDataBlock.select(series, domain);
    }

    public PeriodIterator(TsData series, TsPeriodSelector selector) {
        this.data_ = TsDataBlock.select(series, selector);
    }

    @Override
    public boolean hasMoreElements() {
        if (this.data_ == null) {
            return false;
        }
        return this.cur_ == null || this.cur_.start.getPosition() < this.data_.start.getFrequency().intValue() - 1;
    }

    @Override
    public TsDataBlock nextElement() {
        if (this.cur_ == null) {
            this.initialize();
        } else {
            this.cur_.move(1);
        }
        int nbeg = 0;
        int nend = 0;
        int ifreq = this.data_.start.getFrequency().intValue();
        int cbeg = this.cur_.data.getStartPosition() - ifreq;
        if (cbeg >= this.data_.data.getStartPosition() && cbeg < this.data_.data.getEndPosition()) {
            nbeg = 1;
        }
        if (this.cur_.data.getEndPosition() < this.data_.data.getEndPosition()) {
            nend = 1;
        }
        if (nbeg > 0 || nend > 0) {
            return this.cur_.extend(nbeg, nend);
        }
        return this.cur_;
    }

    public void reset() {
        this.cur_ = null;
    }

    private void initialize() {
        int freq = this.data_.start.getFrequency().intValue();
        int istart = this.data_.start.getPosition();
        if (istart != 0) {
            istart = freq - istart;
        }
        int nyears = (this.data_.data.getLength() - istart) / freq;
        this.cur_ = TsDataBlock.select(this.data_, istart, nyears, freq);
    }
}

