/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.jdr.tests;

import ec.satoolkit.diagnostics.FriedmanTest;
import ec.satoolkit.diagnostics.KruskalWallisTest;
import ec.satoolkit.diagnostics.QSTest;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.information.StatisticalTest;
import ec.tstoolkit.modelling.DifferencingResults;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.RegressionUtilities;
import ec.tstoolkit.timeseries.regression.SeasonalDummies;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.List;

public final class SeasonalityTests {
    public static StatisticalTest ftest(TsData s, boolean ar, int ny) {
        int ifreq = s.getFrequency().intValue();
        if (ar) {
            if (ny != 0) {
                s = s.drop(Math.max(0, s.getLength() - ifreq * ny - 1), 0);
            }
            return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)SeasonalityTests.processAr(s));
        }
        s = s.delta(1);
        if (ny != 0) {
            s = s.drop(Math.max(0, s.getLength() - ifreq * ny), 0);
        }
        return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)SeasonalityTests.process(s));
    }

    public static StatisticalTest qstest(TsData s, int ny, int diff, boolean mean) {
        int freq = s.getFrequency().intValue();
        if (ny != 0) {
            s = s.drop(Math.max(0, s.getLength() - freq * ny), 0);
        }
        DifferencingResults di = DifferencingResults.create((TsData)s, (int)diff, (boolean)mean);
        return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)QSTest.compute((double[])di.getDifferenced().internalStorage(), (int)freq, (int)2));
    }

    public static StatisticalTest kruskalWallisTest(TsData s) {
        KruskalWallisTest test = new KruskalWallisTest(s);
        return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)test);
    }

    public static StatisticalTest friedmanTest(TsData s) {
        FriedmanTest test = new FriedmanTest(s);
        return StatisticalTest.of((ec.tstoolkit.stats.StatisticalTest)test);
    }

    private static ec.tstoolkit.stats.StatisticalTest processAr(TsData s) {
        try {
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock((IReadDataBlock)s);
            reg.setY(y.drop(1, 0));
            TsDomain edomain = s.getDomain().drop(1, 0);
            SeasonalDummies dummies = new SeasonalDummies(edomain.getFrequency());
            List regs = RegressionUtilities.data((ITsVariable)dummies, (TsDomain)edomain);
            reg.addX(y.drop(0, 1));
            for (DataBlock r : regs) {
                reg.addX(r);
            }
            reg.setMeanCorrection(true);
            int nseas = dummies.getDim();
            Ols ols = new Ols();
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 2, nseas, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }

    private static ec.tstoolkit.stats.StatisticalTest process(TsData s) {
        try {
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock((IReadDataBlock)s);
            y.add(-y.average());
            reg.setY(y);
            TsDomain edomain = s.getDomain();
            SeasonalDummies dummies = new SeasonalDummies(edomain.getFrequency());
            List regs = RegressionUtilities.data((ITsVariable)dummies, (TsDomain)edomain);
            for (DataBlock r : regs) {
                reg.addX(r);
            }
            int nseas = dummies.getDim();
            Ols ols = new Ols();
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 0, nseas, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }

    private SeasonalityTests() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

