/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.maths.realfunctions;

import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.maths.realfunctions.IParametersDomain;
import ec.tstoolkit.maths.realfunctions.ParamValidation;

public class DefaultDomain
implements IParametersDomain {
    private int m_n;
    private double m_eps;

    public DefaultDomain(int n, double eps) {
        this.m_n = n;
        this.m_eps = eps;
    }

    @Override
    public boolean checkBoundaries(IReadDataBlock inparams) {
        return true;
    }

    @Override
    public double epsilon(IReadDataBlock inparams, int idx) {
        return inparams.get(idx) * this.m_eps;
    }

    @Override
    public int getDim() {
        return this.m_n;
    }

    @Override
    public String getDescription(int idx) {
        return "parameter " + idx;
    }

    @Override
    public double lbound(int idx) {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double ubound(int idx) {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public ParamValidation validate(IDataBlock ioparams) {
        return ParamValidation.Valid;
    }
}

