/*
 * Decompiled with CFR 0.152.
 */
package ec.satoolkit.diagnostics;

import ec.satoolkit.diagnostics.KruskalWallisTest;
import ec.satoolkit.diagnostics.SeasonalityTest;
import ec.tstoolkit.timeseries.simplets.TsData;

public class CombinedSeasonalityTest {
    private double m_thfs = 0.001;
    private double m_thfm = 0.05;
    private double m_thkw = 0.001;
    private final SeasonalityTest m_stable;
    private final SeasonalityTest m_evolutive;
    private final KruskalWallisTest m_kwtest;

    public CombinedSeasonalityTest(TsData ts, boolean mul) {
        this.m_kwtest = new KruskalWallisTest(ts);
        this.m_stable = SeasonalityTest.stableSeasonality(ts);
        this.m_evolutive = SeasonalityTest.evolutiveSeasonality(ts, mul);
    }

    public SeasonalityTest getEvolutiveSeasonality() {
        return this.m_evolutive;
    }

    public double getMovingSeasonalityAcceptanceLevel() {
        return this.m_thfm;
    }

    public double getNonParametricAcceptanceLevel() {
        return this.m_thkw;
    }

    public KruskalWallisTest getNonParametricTestForStableSeasonality() {
        return this.m_kwtest;
    }

    public SeasonalityTest getStableSeasonality() {
        return this.m_stable;
    }

    public double getStableSeasonalityAcceptanceLevel() {
        return this.m_thfs;
    }

    public IdentifiableSeasonality getSummary() {
        double T2;
        double T22;
        double ps = this.m_stable.getPValue();
        double pm = this.m_evolutive.getPValue();
        if (ps >= this.m_thfs) {
            return IdentifiableSeasonality.None;
        }
        boolean resfm = pm < this.m_thfm;
        double fs = this.m_stable.getValue();
        double fm = this.m_evolutive.getValue();
        double T1 = 7.0 / fs;
        double d = T22 = fs == 0.0 ? 9.0 : 3.0 * fm / fs;
        if (T1 > 9.0) {
            T1 = 9.0;
        }
        if (T22 > 9.0) {
            T22 = 9.0;
        }
        if (resfm && (T2 = Math.sqrt((T1 + T22) / 2.0)) >= 1.0) {
            return IdentifiableSeasonality.None;
        }
        if (T1 >= 1.0 || T22 >= 1.0) {
            return IdentifiableSeasonality.ProbablyNone;
        }
        if (this.m_kwtest.getPValue() >= this.m_thkw) {
            return IdentifiableSeasonality.ProbablyNone;
        }
        return IdentifiableSeasonality.Present;
    }

    public double mvalue() {
        double T2;
        double fs = this.m_stable.getValue();
        double fm = this.m_evolutive.getValue();
        double T1 = 7.0 / fs;
        double d = T2 = fs == 0.0 ? 9.0 : 3.0 * fm / fs;
        if (T1 > 9.0) {
            T1 = 9.0;
        }
        if (T2 > 9.0) {
            T2 = 9.0;
        }
        return Math.sqrt(0.5 * (T1 + T2));
    }

    public void setMovingSeasonalityAcceptanceLevel(double value) {
        this.m_thfm = value;
    }

    public void setNonParametricAcceptanceLevel(double value) {
        this.m_thkw = value;
    }

    public void setStableSeasonalityAcceptanceLevel(double value) {
        this.m_thfs = value;
    }

    public static enum IdentifiableSeasonality {
        None,
        ProbablyNone,
        Present;

    }
}

