/*
 * Decompiled with CFR 0.152.
 */
package ec.tstoolkit.data;

import ec.tstoolkit.data.IDataBlock;
import ec.tstoolkit.data.IDataNormalizer;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.InPlaceNormalizer;

public class AbsMeanNormalizer
implements IDataNormalizer,
InPlaceNormalizer {
    private double m_c;
    private double[] m_data;

    @Override
    public double getFactor() {
        return this.m_c;
    }

    @Override
    public double[] getNormalizedData() {
        return this.m_data;
    }

    private boolean process() {
        int i;
        double s = 0.0;
        int n = 0;
        for (i = 0; i < this.m_data.length; ++i) {
            double d = this.m_data[i];
            if (!Double.isFinite(d)) continue;
            s += Math.abs(d);
            ++n;
        }
        if (s == 0.0) {
            return false;
        }
        this.m_c = (double)n / s;
        for (i = 0; i < this.m_data.length; ++i) {
            if (!Double.isFinite(this.m_data[i])) continue;
            int n2 = i;
            this.m_data[n2] = this.m_data[n2] * this.m_c;
        }
        return true;
    }

    @Override
    public boolean process(IReadDataBlock data) {
        this.m_c = 1.0;
        this.m_data = new double[data.getLength()];
        data.copyTo(this.m_data, 0);
        return this.process();
    }

    @Override
    public double normalize(IDataBlock data) {
        double s = 0.0;
        int n = data.getLength();
        int m = 0;
        for (int i = 0; i < n; ++i) {
            double d = data.get(i);
            if (!Double.isFinite(d)) continue;
            s += Math.abs(d);
            ++m;
        }
        if (s == 0.0) {
            return 1.0;
        }
        double c = (double)m / s;
        data.apply(x -> x * c);
        return c;
    }
}

