\name{wordcloud_rjs}
\alias{wordcloud_rjs}
\title{Draw a wordcloud.}
\author{
David Barrios and Carlos Prieto. Bioinformatics Service of Nucleus, University of Salamanca. See \url{http://bioinfo.usal.es/}
}
\value{
The function creates a folder in your computer with an HTML document named index.html which contains the graph. This file can be directly opened with your browser.
}
\seealso{
  The \sQuote{RJSplot} Website: \url{http://rjsplot.net}

  \code{\link{dendrogram_rjs}}, \code{\link{densityplot_rjs}}, \code{\link{genomemap_rjs}}, \code{\link{heatmap_rjs}}, \code{\link{manhattan_rjs}}, \code{\link{network_rjs}}, \code{\link{scatterplot_rjs}}, \code{\link{symheatmap_rjs}}, \code{\link{wordcloud_rjs}}, \code{\link{boxplot_rjs}}, \code{\link{bubbles_rjs}}, \code{\link{hiveplot_rjs}}, \code{\link{piechart_rjs}}, \code{\link{barplot_rjs}}, \code{\link{tables_rjs}}, \code{\link{surface3d_rjs}}, \code{\link{scatter3d_rjs}}.
}
\usage{
wordcloud_rjs(data, plot = TRUE, jupyter = FALSE, dir = "WordCloud")
}
\arguments{
\item{data}{a two column data Frame with the words to display and their frecuency.}
\item{plot}{open resulting graph in your browser.}
\item{jupyter}{embed the graph as an iframe into a Jupyter Notebook.}
\item{dir}{a "character" string representing the directory where the graph will be saved.}
}
\description{
\code{wordcloud_rjs} creates a wordcloud.
}
\examples{
## Create an interactive heatmap in the folder "WordCloud" of your local machine
## Live examples on http://rjsplot.net

## Format test data
words <- data.frame(word = rownames(USArrests), freq = USArrests[,4])

# Create WordCloud
wordcloud_rjs(words)
}
