% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotCBMFit.R
\name{PlotCbmFit}
\alias{PlotCbmFit}
\title{Plot CBM fitted curve}
\usage{
PlotCbmFit (mu, alpha)
}
\arguments{
\item{mu}{vector: the mean(s) of the z-samples of the diseased distribution(s) where the disease is visible}

\item{alpha}{vector: the proportion(s) of the diseased distribution(s) where the disease is visible}
}
\value{
A \pkg{ggplot2} object of the plotted ROC curve(s)
}
\description{
Plot the CBM-predicted ROC curve with provided CBM parameters
}
\details{
\code{mu} and \code{alpha} must have equal length. 
The predicted ROC curve for each \code{mu} and \code{alpha} pair will be plotted.
}
\examples{
cbmPlot <- PlotCbmFit(c(1, 2), c(0.5, 0.5))
print(cbmPlot)


}
\references{
Dorfman DD, Berbaum KS (2000) A contaminated binormal model for ROC data: Part II. 
A formal model, Acad Radiol 7, 427--437.
}
