% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dataset11}
\alias{dataset11}
\title{Dobbins 1 FROC dataset}
\format{A list with 8 elements:
\itemize{
\item{\code{NL}}{ Ratings array [1:4, 1:5, 1:158, 1:4], of non-lesion localizations, NLs}
\item{\code{LL}}{ Ratings array [1:4, 1:5, 1:115, 1:20], of lesion localizations, LLs}
\item{\code{lesionNum}}{ array [1:115], number of lesions per diseased case}
\item{\code{lesionID}}{ array [1:115, 20], labels of lesions on diseased cases, all set to 1}
\item{\code{lesionWeight}}{ array [1:115, 20] weights (or clinical importance) of lesions, all set to 1}
\item{\code{dataType}}{ "FROC", the data type}
\item{\code{modalityID}}{ [1:4] "1" "2" ..., treatment labels}
\item{\code{readerID}}{ [1:5] "1" "2" ..., reader labels}
}}
\usage{
dataset11
}
\description{
This is referred to in the book as the "DOB1" dataset. Dobbins et al conducted a 
multi-institutional, MRMC study to compare the performance of digital tomosynthesis 
(GE's VolumeRad device), dual-energy (DE) imaging, and conventional chest 
radiography for pulmonary nodule detection and management. 
All study images were obtained with a flat-panel detector developed by GE. 
The case set consisted of 158 subjects, of which 43 were non-diseased and 
the rest had 1 - 20 pulmonary nodules independently verified, using with CT 
images, by 3 experts who did not participate in the observer study. The 
study used FROC paradigm data collection. There are 
4 treatments labeled 1 - 4 (conventional chest x-ray, CXR, CXR augmented
with dual-energy (CXR+DE), VolumeRad digital tomosynthesis images and 
VolumeRad augmented with DE (VolumeRad+DE).
}
\examples{
str(dataset11)


}
\references{
Dobbins III JT et al. Multi-Institutional Evaluation of Digital 
Tomosynthesis, Dual-Energy Radiography, and Conventional Chest Radiography 
for the Detection and Management of Pulmonary Nodules. Radiology. 2016;282(1):236-250.
}
\keyword{datasets}
