% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UtilLesionWeightsDistr.R
\name{UtilLesionWeightsDistr}
\alias{UtilLesionWeightsDistr}
\title{Lesion weights distribution}
\usage{
UtilLesionWeightsDistr(dataset)
}
\arguments{
\item{dataset}{The supplied dataset.}
}
\value{
lesWghtDistr The lesion weights distribution, an [1:nRow,1:(maxLL+1)] 
   array, where nRow is the number of lesions per case in the dataset and 
   maxLL is the maximum number of lesions per case in the dataset. The first 
   column contains the number of lesions per case, while the remaining columns 
   contain the weights (equal weighting assumed). Missing values are filled with -Inf.
   This parameter is not to be confused with the lesionWeight list member in an FROC
   dataset, which enumerates the weights of lesions on \bold{individual} cases. See 
   \link{PlotRsmOperatingCharacteristics} for a function that depends on lesWghtDistr.See 
   Chapter00Vignette2 for fuller explanation.
}
\description{
The lesion weights  distribution, assuming equal weights. 
   Needed to plot empirical curves for FROC data (ROC, wAFROC).
}
\examples{
UtilLesionWeightsDistr (dataset11) # FROC data
UtilLesionWeightsDistr (dataset02) # ROC data
UtilLesionWeightsDistr (datasetCadLroc) # LROC data

}
