% Generated by roxygen2 (4.0.2): do not edit by hand
\name{extractmonths}
\alias{extractmonths}
\title{Extracts the rows of a matrix corresponding to requested months of a year given the  date (origin) of the first row}
\usage{
extractmonths(data = array(1:ndim_max, dim = c(ndim_max, 1)),
  ndim_max = 1e+05, when = c("Dec", "Jan", "Feb"), year = NULL,
  origin = "1961-1-1")
}
\arguments{
\item{data}{an input data matrix where each row corresponds to a daily record}

\item{ndim_max}{maximum (integer) number of rows in \code{data} where to find \code{when}.
Default is 100000 and works if \code{data} is missing.}

\item{when}{character vactor of months for which the data are required.
It must be a subset of \code{c("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec")}}

\item{year}{year(s) when data must be extracted}

\item{origin}{date corresponding to the first row of \code{data}}
}
\value{
a matrix containing the requested rows
}
\description{
Extracts the rows of a matrix corresponding to requested months of a year given the  date (origin) of the first row
}
\note{
It uses \code{\link{months}} and  \code{\link{julian}}
}
\author{
Emanuele Cordano, Emanuele Eccel
}
\seealso{
\code{\link{extractdays}}
}

