require("RMVL")
 
M3<-mvl_open("test2.mvl", append=TRUE, create=TRUE)

L<-list()

df<-data.frame(x=1:1e5, y=rnorm(1e5), s=rep(c("a", "b"), 5e4), b=rnorm(1e5)<0.5)
L[["x"]]<-mvl_write_object(M3, df)

aa<-array(rnorm(10000), c(10, 50, 20))
L[["y"]]<-aa

mm<-matrix(rnorm(10000), 10, 1000)
L[["z"]]<-mm

LL2<-as.list(rnorm(10000))
names(LL2)<-paste("x", 1:10000, sep="")
L[["LL2"]]<-LL2

L[["description"]]<-"Example of large data frame"
mvl_write_object(M3, L, "test_object")

LM1<-lm(rnorm(100)~runif(100))
mvl_write_serialized_object(M3, LM1, "LM1")

mvl_close(M3)

M3<-mvl_open("test2.mvl")
print(names(M3))
L2<-M3["test_object"]

N<-dim(df)[1]

compare_df<-function(x, y) {
	if(length(dim(x))!=length(dim(y)))return(FALSE)
	if(any(dim(x)!=dim(y)))return(FALSE)
	if(any(names(x)!=names(y)))return(FALSE)
	if(dim(x)[2]>0) {
		for(i in 1:(dim(x)[2])) {
			if(any(x[,i]!=y[,i]))return(FALSE)
			}
		}
	return(TRUE)
	}

if(!compare_df(df, L2[["x"]][,])) {
	cat("test1a failed\n")
	print(attributes(df))
	print(attributes(L2[["x"]][,]))
	cat("-----------\n")
	}
if(!compare_df(df[1:20,], L2[["x"]][1:20,]))cat("test1b failed\n")

if(!compare_df(df[(1:N) %% 5==0,], L2[["x"]][(1:N) %% 5==0,]))cat("test2 failed\n")

if(!compare_df(df[(1:N) %% 5==0,], L2[["x"]][(1:N)[(1:N) %% 5==0],]))cat("test3 failed\n")

if(!compare_df(df[(1:N) %% 5==0, c("y", "s")], L2[["x"]][(1:N)[(1:N) %% 5==0], c("y", "s")]))cat("test4 failed\n")

if(!identical(df[(1:N) %% 5==0, c("s")], L2[["x"]][(1:N)[(1:N) %% 5==0], c("s")]))cat("test5 failed\n")

if(!compare_df(df[(1:N) %% 5==0, 2:3], L2[["x"]][(1:N)[(1:N) %% 5==0], 2:3]))cat("test6 failed\n")

if(!isTRUE(all.equal(aa, L2[["y"]][])))cat("test7 failed\n")
if(!compare_df(mm, L2[["z"]][])) {
	cat("test8 failed\n")
	print(all.equal(mm, L2[["z"]][]))
	print(attributes(mm))
	print(attributes(L2[["z"]][]))
	cat("-----------\n")
	}

if(!isTRUE(all.equal(aa[c(2,3,5),,], L2[["y"]][c(2,3,5),,])))cat("test9 failed\n")
if(!isTRUE(all.equal(aa[,c(2,3,5),], L2[["y"]][,c(2,3,5),])))cat("test10 failed\n")
if(!isTRUE(all.equal(aa[,,c(2,3,5)], L2[["y"]][,,c(2,3,5)])))cat("test11 failed\n")
if(!isTRUE(all.equal(aa[c(2,3,5),c(6,10,20),c(7,3,5)], L2[["y"]][c(2,3,5),c(6,10,20),c(7,3,5)])))cat("test12 failed\n")

if(!isTRUE(all.equal(mm[c(2,3,5),], L2[["z"]][c(2,3,5),])))cat("test13 failed\n")
if(!isTRUE(all.equal(mm[,c(2,3,5)], L2[["z"]][,c(2,3,5)])))cat("test14 failed\n")
if(!isTRUE(all.equal(mm[c(2,3,5),c(6,10,20)], L2[["z"]][c(2,3,5),c(6,10,20)])))cat("test15 failed\n")

if(!isTRUE(all.equal(LL2, L2[["LL2"]][]))) {
	cat("test16 failed\n")
	print(all.equal(LL2, L2[["LL2"]][]))
	cat("-----------\n")
	}

idx1<-20:2001
if(!isTRUE(all.equal(LL2[idx1], L2[["LL2"]][idx1]))) {
	cat("test17 failed\n")
	print(all.equal(LL2[idx1], L2[["LL2"]][idx1]))
	cat("-----------\n")
	}
	
if(!isTRUE(all.equal(LL2[5], L2[["LL2"]][5]))) {
	cat("test18 failed\n")
	print(all.equal(LL2[5], L2[["LL2"]][5]))
	print(LL2[5])
	print(L2[["LL2"]][5])
	cat("-----------\n")
	}

if(!identical(LM1, mvl2R(M3["LM1"]))) {
	cat("test19 failed\n")
	print(all.equal(LM1, mvl2R(M3["LM1"])))
	cat("-----------\n")
	}
	
# TODO:
# Testing of [,raw=TRUE] is complicated because R's as.raw() function is only meant for conversion of characters,
# while MVL raw mode only returns raw vectors when there is no equivalent R vector (such as the case of floats and INT64)
#
# if(!isTRUE(all.equal(as.raw(aa[c(2,3,5),c(6,10,20),c(7,3,5)]), L2[["y"]][c(2,3,5),c(6,10,20),c(7,3,5),raw=TRUE]))){
# 	cat("test19 failed\n")
# 	print(all.equal(as.raw(aa[c(2,3,5),c(6,10,20),c(7,3,5)]), L2[["y"]][c(2,3,5),c(6,10,20),c(7,3,5),raw=TRUE]))
# 	print(as.raw(aa[c(2,3,5),c(6,10,20),c(7,3,5)]))
# 	print(L2[["y"]][c(2,3,5),c(6,10,20),c(7,3,5),raw=TRUE])
# 	cat("-----------\n")
# 	}
	
print(mvl_object_stats(L2[["x"]])[c("length", "type")])
print(mvl_object_stats(L2[["y"]])[c("length", "type")])
print(mvl_object_stats(L2[["z"]])[c("length", "type")])
print(mvl_object_stats(L2[["LL2"]])[c("length", "type")])

mvl_close(M3)

unlink("test2.mvl")

