% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIXTCOMP_getter.R
\name{getType}
\alias{getType}
\alias{getModel}
\alias{getVarNames}
\title{Names and Types Getters}
\usage{
getType(outMixtComp, with.z_class = FALSE)

getModel(outMixtComp, with.z_class = FALSE)

getVarNames(outMixtComp, with.z_class = FALSE)
}
\arguments{
\item{outMixtComp}{object of class \emph{MixtCompLearn} or \emph{MixtComp} obtained using \code{mixtCompLearn} or \code{mixtCompPredict} functions from \code{RMixtComp} package or \code{rmcMultiRun} from \code{RMixtCompIO} package.}

\item{with.z_class}{if TRUE, the type of z_class is returned.}
}
\value{
a vector containing the type of models, names associated with each individual.
}
\description{
getType returns the type output of a MixtComp object, getModel returns the model object, getVarNames returns the name for each variable
}
\examples{
require(RMixtCompIO) # for learning a mixture model
dataLearn <- list(var1 = as.character(c(rnorm(50, -2, 0.8), rnorm(50, 2, 0.8))),
                  var2 = as.character(c(rnorm(50, 2), rpois(50, 8))))
                  
model <- list(var1 = list(type = "Gaussian", paramStr = ""),
              var2 = list(type = "Poisson", paramStr = ""))

algo <- list(
  nClass = 2,
  nInd = 100,
  nbBurnInIter = 100,
  nbIter = 100,
  nbGibbsBurnInIter = 100,
  nbGibbsIter = 100,
  nInitPerClass = 3,
  nSemTry = 20,
  confidenceLevel = 0.95,
  ratioStableCriterion = 0.95,
  nStableCriterion = 10,
  mode = "learn"
)

resLearn <- rmcMultiRun(algo, dataLearn, model, nRun = 3)

# get type
type <- getType(resLearn)

# get model object
model <- getModel(resLearn)

# get variable names
varNames <- getVarNames(resLearn)


}
\seealso{
Other getter: \code{\link{getBIC}},
  \code{\link{getCompletedData}},
  \code{\link{getEmpiricTik}}, \code{\link{getParam}},
  \code{\link{getPartition}}
}
\author{
Quentin Grimonprez
}
\concept{getter}
