/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.Bytes;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBDecoderFactory;
import com.mongodb.DBObject;
import com.mongodb.GroupCommand;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoException;
import com.mongodb.ReflectionDBObject;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBCollection {
    final DB _db;
    protected final String _name;
    protected final String _fullName;
    protected List<DBObject> _hintFields;
    private WriteConcern _concern = null;
    final Bytes.OptionHolder _options;
    protected Class _objectClass = null;
    private Map<String, Class> _internalClass = Collections.synchronizedMap(new HashMap());
    private ReflectionDBObject.JavaWrapper _wrapper = null;
    private final Set<String> _createdIndexes = new HashSet<String>();
    private DBDecoderFactory dbDecoderFactory;

    public abstract WriteResult insert(DBObject[] var1, WriteConcern var2) throws MongoException;

    public WriteResult insert(DBObject o, WriteConcern concern) throws MongoException {
        return this.insert(new DBObject[]{o}, concern);
    }

    public WriteResult insert(DBObject ... arr) throws MongoException {
        return this.insert(arr, this.getWriteConcern());
    }

    public WriteResult insert(List<DBObject> list) throws MongoException {
        return this.insert(list.toArray(new DBObject[list.size()]), this.getWriteConcern());
    }

    public WriteResult insert(List<DBObject> list, WriteConcern concern) throws MongoException {
        return this.insert(list.toArray(new DBObject[list.size()]), concern);
    }

    public abstract WriteResult update(DBObject var1, DBObject var2, boolean var3, boolean var4, WriteConcern var5) throws MongoException;

    public WriteResult update(DBObject q, DBObject o, boolean upsert, boolean multi) throws MongoException {
        return this.update(q, o, upsert, multi, this.getWriteConcern());
    }

    public WriteResult update(DBObject q, DBObject o) throws MongoException {
        return this.update(q, o, false, false);
    }

    public WriteResult updateMulti(DBObject q, DBObject o) throws MongoException {
        return this.update(q, o, false, true);
    }

    protected abstract void doapply(DBObject var1);

    public abstract WriteResult remove(DBObject var1, WriteConcern var2) throws MongoException;

    public WriteResult remove(DBObject o) throws MongoException {
        return this.remove(o, this.getWriteConcern());
    }

    abstract Iterator<DBObject> __find(DBObject var1, DBObject var2, int var3, int var4, int var5, int var6) throws MongoException;

    @Deprecated
    public final DBCursor find(DBObject query, DBObject fields, int numToSkip, int batchSize, int options) throws MongoException {
        return this.find(query, fields, numToSkip, batchSize).addOption(options);
    }

    @Deprecated
    public final DBCursor find(DBObject query, DBObject fields, int numToSkip, int batchSize) {
        DBCursor cursor = this.find(query, fields).skip(numToSkip).batchSize(batchSize);
        return cursor;
    }

    public final DBObject findOne(Object obj) throws MongoException {
        return this.findOne(obj, null);
    }

    public final DBObject findOne(Object obj, DBObject fields) {
        Iterator<DBObject> iterator2 = this.__find(new BasicDBObject("_id", obj), fields, 0, -1, 0, this.getOptions());
        return iterator2 != null ? iterator2.next() : null;
    }

    public DBObject findAndModify(DBObject query, DBObject fields, DBObject sort2, boolean remove2, DBObject update2, boolean returnNew, boolean upsert) {
        BasicDBObject cmd = new BasicDBObject("findandmodify", this._name);
        if (query != null && !query.keySet().isEmpty()) {
            cmd.append("query", query);
        }
        if (fields != null && !fields.keySet().isEmpty()) {
            cmd.append("fields", fields);
        }
        if (sort2 != null && !sort2.keySet().isEmpty()) {
            cmd.append("sort", sort2);
        }
        if (remove2) {
            cmd.append("remove", remove2);
        } else {
            if (update2 != null && !update2.keySet().isEmpty()) {
                String key = update2.keySet().iterator().next();
                if (key.charAt(0) != '$') {
                    this._checkObject(update2, false, false);
                }
                cmd.append("update", update2);
            }
            if (returnNew) {
                cmd.append("new", returnNew);
            }
            if (upsert) {
                cmd.append("upsert", upsert);
            }
        }
        if (remove2 && update2 != null && !update2.keySet().isEmpty() && !returnNew) {
            throw new MongoException("FindAndModify: Remove cannot be mixed with the Update, or returnNew params!");
        }
        CommandResult res = this._db.command(cmd);
        if (res.ok() || res.getErrorMessage().equals("No matching object found")) {
            return (DBObject)res.get("value");
        }
        res.throwOnError();
        return null;
    }

    public DBObject findAndModify(DBObject query, DBObject sort2, DBObject update2) {
        return this.findAndModify(query, null, sort2, false, update2, false, false);
    }

    public DBObject findAndModify(DBObject query, DBObject update2) {
        return this.findAndModify(query, null, null, false, update2, false, false);
    }

    public DBObject findAndRemove(DBObject query) {
        return this.findAndModify(query, null, null, true, null, false, false);
    }

    public final void createIndex(DBObject keys) throws MongoException {
        this.createIndex(keys, this.defaultOptions(keys));
    }

    public abstract void createIndex(DBObject var1, DBObject var2) throws MongoException;

    public final void ensureIndex(String name) {
        this.ensureIndex(new BasicDBObject(name, (Object)1));
    }

    public final void ensureIndex(DBObject keys) throws MongoException {
        this.ensureIndex(keys, this.defaultOptions(keys));
    }

    public void ensureIndex(DBObject keys, String name) throws MongoException {
        this.ensureIndex(keys, name, false);
    }

    public void ensureIndex(DBObject keys, String name, boolean unique) throws MongoException {
        DBObject options = this.defaultOptions(keys);
        if (name != null && !name.isEmpty()) {
            options.put("name", name);
        }
        if (unique) {
            options.put("unique", Boolean.TRUE);
        }
        this.ensureIndex(keys, options);
    }

    public final void ensureIndex(DBObject keys, DBObject optionsIN) throws MongoException {
        if (this.checkReadOnly(false)) {
            return;
        }
        DBObject options = this.defaultOptions(keys);
        for (String k : optionsIN.keySet()) {
            options.put(k, optionsIN.get(k));
        }
        String name = options.get("name").toString();
        if (this._createdIndexes.contains(name)) {
            return;
        }
        this.createIndex(keys, options);
        this._createdIndexes.add(name);
    }

    public void resetIndexCache() {
        this._createdIndexes.clear();
    }

    DBObject defaultOptions(DBObject keys) {
        BasicDBObject o = new BasicDBObject();
        o.put("name", (Object)DBCollection.genIndexName(keys));
        o.put("ns", (Object)this._fullName);
        return o;
    }

    public static String genIndexName(DBObject keys) {
        StringBuilder name = new StringBuilder();
        for (String s : keys.keySet()) {
            if (name.length() > 0) {
                name.append('_');
            }
            name.append(s).append('_');
            Object val = keys.get(s);
            if (!(val instanceof Number) && !(val instanceof String)) continue;
            name.append(val.toString().replace(' ', '_'));
        }
        return name.toString();
    }

    public void setHintFields(List<DBObject> lst) {
        this._hintFields = lst;
    }

    public final DBCursor find(DBObject ref) {
        return new DBCursor(this, ref, null);
    }

    public final DBCursor find(DBObject ref, DBObject keys) {
        return new DBCursor(this, ref, keys);
    }

    public final DBCursor find() {
        return new DBCursor(this, new BasicDBObject(), null);
    }

    public final DBObject findOne() throws MongoException {
        return this.findOne(new BasicDBObject());
    }

    public final DBObject findOne(DBObject o) throws MongoException {
        return this.findOne(o, null);
    }

    public final DBObject findOne(DBObject o, DBObject fields) {
        DBObject obj;
        Iterator<DBObject> i = this.__find(o, fields, 0, -1, 0, this.getOptions());
        DBObject dBObject = obj = i == null ? null : i.next();
        if (obj != null && fields != null && fields.keySet().size() > 0) {
            obj.markAsPartialObject();
        }
        return obj;
    }

    public final Object apply(DBObject o) {
        return this.apply(o, true);
    }

    public final Object apply(DBObject jo, boolean ensureID) {
        Object id = jo.get("_id");
        if (ensureID && id == null) {
            id = ObjectId.get();
            jo.put("_id", id);
        }
        this.doapply(jo);
        return id;
    }

    public final WriteResult save(DBObject jo) {
        return this.save(jo, this.getWriteConcern());
    }

    public final WriteResult save(DBObject jo, WriteConcern concern) throws MongoException {
        if (this.checkReadOnly(true)) {
            return null;
        }
        this._checkObject(jo, false, false);
        Object id = jo.get("_id");
        if (id == null || id instanceof ObjectId && ((ObjectId)id).isNew()) {
            if (id != null && id instanceof ObjectId) {
                ((ObjectId)id).notNew();
            }
            if (concern == null) {
                return this.insert(jo);
            }
            return this.insert(jo, concern);
        }
        BasicDBObject q = new BasicDBObject();
        q.put("_id", id);
        if (concern == null) {
            return this.update(q, jo, true, false);
        }
        return this.update(q, jo, true, false, concern);
    }

    public void dropIndexes() throws MongoException {
        this.dropIndexes("*");
    }

    public void dropIndexes(String name) throws MongoException {
        DBObject cmd = BasicDBObjectBuilder.start().add("deleteIndexes", this.getName()).add("index", name).get();
        this.resetIndexCache();
        CommandResult res = this._db.command(cmd);
        if (res.ok() || res.getErrorMessage().equals("ns not found")) {
            return;
        }
        res.throwOnError();
    }

    public void drop() throws MongoException {
        this.resetIndexCache();
        CommandResult res = this._db.command(BasicDBObjectBuilder.start().add("drop", this.getName()).get());
        if (res.ok() || res.getErrorMessage().equals("ns not found")) {
            return;
        }
        res.throwOnError();
    }

    public long count() throws MongoException {
        return this.getCount(new BasicDBObject(), null);
    }

    public long count(DBObject query) throws MongoException {
        return this.getCount(query, null);
    }

    public long getCount() throws MongoException {
        return this.getCount(new BasicDBObject(), null);
    }

    public long getCount(DBObject query) throws MongoException {
        return this.getCount(query, null);
    }

    public long getCount(DBObject query, DBObject fields) throws MongoException {
        return this.getCount(query, fields, 0L, 0L);
    }

    public long getCount(DBObject query, DBObject fields, long limit, long skip) throws MongoException {
        CommandResult res;
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("count", (Object)this.getName());
        cmd.put("query", (Object)query);
        if (fields != null) {
            cmd.put("fields", (Object)fields);
        }
        if (limit > 0L) {
            cmd.put("limit", (Object)limit);
        }
        if (skip > 0L) {
            cmd.put("skip", (Object)skip);
        }
        if (!(res = this._db.command(cmd, this.getOptions())).ok()) {
            String errmsg = res.getErrorMessage();
            if (errmsg.equals("ns does not exist") || errmsg.equals("ns missing")) {
                return 0L;
            }
            res.throwOnError();
        }
        return res.getLong("n");
    }

    public DBCollection rename(String newName) throws MongoException {
        return this.rename(newName, false);
    }

    public DBCollection rename(String newName, boolean dropTarget) throws MongoException {
        CommandResult ret = this._db.getSisterDB("admin").command(BasicDBObjectBuilder.start().add("renameCollection", this._fullName).add("to", this._db._name + "." + newName).add("dropTarget", dropTarget).get());
        ret.throwOnError();
        this.resetIndexCache();
        return this._db.getCollection(newName);
    }

    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce2) throws MongoException {
        return this.group(key, cond, initial, reduce2, null);
    }

    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce2, String finalize) throws MongoException {
        GroupCommand cmd = new GroupCommand(this, key, cond, initial, reduce2, finalize);
        return this.group(cmd);
    }

    public DBObject group(GroupCommand cmd) {
        CommandResult res = this._db.command(cmd.toDBObject(), this.getOptions());
        res.throwOnError();
        return (DBObject)res.get("retval");
    }

    @Deprecated
    public DBObject group(DBObject args) throws MongoException {
        args.put("ns", this.getName());
        CommandResult res = this._db.command(new BasicDBObject("group", args), this.getOptions());
        res.throwOnError();
        return (DBObject)res.get("retval");
    }

    public List distinct(String key) {
        return this.distinct(key, new BasicDBObject());
    }

    public List distinct(String key, DBObject query) {
        DBObject c = BasicDBObjectBuilder.start().add("distinct", this.getName()).add("key", key).add("query", query).get();
        CommandResult res = this._db.command(c, this.getOptions());
        res.throwOnError();
        return (List)res.get("values");
    }

    public MapReduceOutput mapReduce(String map2, String reduce2, String outputTarget, DBObject query) throws MongoException {
        return this.mapReduce(new MapReduceCommand(this, map2, reduce2, outputTarget, MapReduceCommand.OutputType.REPLACE, query));
    }

    public MapReduceOutput mapReduce(String map2, String reduce2, String outputTarget, MapReduceCommand.OutputType outputType, DBObject query) throws MongoException {
        return this.mapReduce(new MapReduceCommand(this, map2, reduce2, outputTarget, outputType, query));
    }

    public MapReduceOutput mapReduce(MapReduceCommand command) throws MongoException {
        DBObject cmd = command.toDBObject();
        CommandResult res = null;
        res = command.getOutputType() == MapReduceCommand.OutputType.INLINE ? this._db.command(cmd, this.getOptions()) : this._db.command(cmd);
        res.throwOnError();
        return new MapReduceOutput(this, cmd, res);
    }

    public MapReduceOutput mapReduce(DBObject command) throws MongoException {
        if (command.get("mapreduce") == null && command.get("mapReduce") == null) {
            throw new IllegalArgumentException("need mapreduce arg");
        }
        CommandResult res = this._db.command(command);
        res.throwOnError();
        return new MapReduceOutput(this, command, res);
    }

    public List<DBObject> getIndexInfo() {
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("ns", (Object)this.getFullName());
        DBCursor cur = this._db.getCollection("system.indexes").find(cmd);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        while (cur.hasNext()) {
            list.add(cur.next());
        }
        return list;
    }

    public void dropIndex(DBObject keys) throws MongoException {
        this.dropIndexes(DBCollection.genIndexName(keys));
    }

    public void dropIndex(String name) throws MongoException {
        this.dropIndexes(name);
    }

    public CommandResult getStats() {
        return this.getDB().command(new BasicDBObject("collstats", this.getName()), this.getOptions());
    }

    public boolean isCapped() {
        CommandResult stats = this.getStats();
        Object capped = stats.get("capped");
        return capped != null && (Integer)capped == 1;
    }

    protected DBCollection(DB base, String name) {
        this._db = base;
        this._name = name;
        this._fullName = this._db.getName() + "." + name;
        this._options = new Bytes.OptionHolder(this._db._options);
    }

    protected DBObject _checkObject(DBObject o, boolean canBeNull, boolean query) {
        if (o == null) {
            if (canBeNull) {
                return null;
            }
            throw new IllegalArgumentException("can't be null");
        }
        if (o.isPartialObject() && !query) {
            throw new IllegalArgumentException("can't save partial objects");
        }
        if (!query) {
            this._checkKeys(o);
        }
        return o;
    }

    private void _checkKeys(DBObject o) {
        for (String s : o.keySet()) {
            if (s.contains(".")) {
                throw new IllegalArgumentException("fields stored in the db can't have . in them");
            }
            if (s.startsWith("$")) {
                throw new IllegalArgumentException("fields stored in the db can't start with '$'");
            }
            Object inner2 = o.get(s);
            if (!(inner2 instanceof DBObject)) continue;
            this._checkKeys((DBObject)inner2);
        }
    }

    public DBCollection getCollection(String n) {
        return this._db.getCollection(this._name + "." + n);
    }

    public String getName() {
        return this._name;
    }

    public String getFullName() {
        return this._fullName;
    }

    public DB getDB() {
        return this._db;
    }

    protected boolean checkReadOnly(boolean strict) {
        if (!this._db._readOnly) {
            return false;
        }
        if (!strict) {
            return true;
        }
        throw new IllegalStateException("db is read only");
    }

    public int hashCode() {
        return this._fullName.hashCode();
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public String toString() {
        return this._name;
    }

    public void setObjectClass(Class c) {
        if (c == null) {
            this._wrapper = null;
            this._objectClass = null;
            return;
        }
        if (!DBObject.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException(c.getName() + " is not a DBObject");
        }
        this._objectClass = c;
        this._wrapper = ReflectionDBObject.class.isAssignableFrom(c) ? ReflectionDBObject.getWrapper(c) : null;
    }

    public Class getObjectClass() {
        return this._objectClass;
    }

    public void setInternalClass(String path, Class c) {
        this._internalClass.put(path, c);
    }

    protected Class getInternalClass(String path) {
        Class c = this._internalClass.get(path);
        if (c != null) {
            return c;
        }
        if (this._wrapper == null) {
            return null;
        }
        return this._wrapper.getInternalClass(path);
    }

    public void setWriteConcern(WriteConcern concern) {
        this._concern = concern;
    }

    public WriteConcern getWriteConcern() {
        if (this._concern != null) {
            return this._concern;
        }
        return this._db.getWriteConcern();
    }

    public void slaveOk() {
        this.addOption(4);
    }

    public void addOption(int option) {
        this._options.add(option);
    }

    public void setOptions(int options) {
        this._options.set(options);
    }

    public void resetOptions() {
        this._options.reset();
    }

    public int getOptions() {
        return this._options.get();
    }

    public void setDBDecoderFactory(DBDecoderFactory dbDecoderFactory) {
        this.dbDecoderFactory = dbDecoderFactory;
    }

    public DBDecoderFactory getDBDecoderFactory() {
        return this.dbDecoderFactory;
    }
}

