\name{multi_branch_loop}
\alias{multi_branch_loop}
\title{multi_branch_loop}
\usage{
multi_branch_loop(ctFile)
}
\arguments{
\item{ctFile}{A RNA secondary structure file without the first line of free energy information}
}
\description{
Given a RNA secondary structure,it compute multi-branch loops in the RNA secondary structure
}
\value{
Return a list containing base positions in multi-branch loops,and the length of the number of multi-branch loops
}
\examples{
###
col1 <- c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20
,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40
,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60
,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80
,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100
,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115
,116,117,118,119)
col2 <- c("C","C","U","A","G","U","G","A","C","A","A","U","A"
,"G","C","G","A","G","A","G","A","G","G","A","A","A","C","A"
,"C","C","C","G","U","C","U","C","C","A","U","C","C","C","G"
,"A","A","C","A","C","G","A","A","G","G","U","U","A","A","G"
,"C","U","C","U","C","C","C","A","G","C","G","C","C","G","A"
,"U","G","G","U","A","G","U","U","G","G","G","G","C","C","A"
,"G","C","G","C","C","C","C","U","G","C","A","A","G","A","G"
,"U","A","G","G","U","U","G","U","C","G","C","U","A","G","G"
,"C")
col3 <- c(0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19
,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39
,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59
,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79
,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99
,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114
,115,116,117,118)
col4 <- c(2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21
,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41
,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61
,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81
,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100
,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115
,116,117,118,119,120)
col5 <- c(118,117,116,115,114,113,112,111,0,0,0,0,0,67,66,64
,63,62,0,61,60,59,0,0,0,0,55,54,53,50,49,48,47,0,0,0,0,0,0,0
,0,0,0,0,0,0,33,32,31,30,0,0,29,28,27,0,0,0,22,21,20,18,17,16
,0,15,14,0,0,107,106,105,104,103,102,101,0,0,98,97,96,95,94
,93,92,91,0,0,0,0,86,85,84,83,82,81,80,79,0,0,76,75,74,73,72
,71,70,0,0,0,8,7,6,5,4,3,2,1,0)
col6 <- c(1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20
,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40
,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60
,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80
,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100
,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115
,116,117,118,119)

data <- matrix(c(col1,col2,col3,col4,col5,col6),byrow=FALSE,ncol =6)
multi_branch_loop(data)
}
