% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RN.R
\name{rankNorm}
\alias{rankNorm}
\title{Rank-Normalize}
\usage{
rankNorm(u, k = 3/8)
}
\arguments{
\item{u}{Numeric vector.}

\item{k}{Offset. Defaults to (3/8), correspond to the Blom transform.}
}
\value{
Numeric vector of rank normalized measurements.
}
\description{
Applies the rank based inverse normal transform (INT) to a numeric vector.
The INT can be broken down into a two-step procedure. In the first, the
observations are transformed onto the probability scale using the empirical
cumulative distribution function (ECDF). In the second, the observations are
transformed onto the real line, as Z-scores, using the probit function.
}
\examples{
\dontrun{
# Draw from chi-1 distribution
y = rchisq(n=1e3,df=1);
# Rank normalize
z = rankNorm(y);
# Plot density of transformed measurement
plot(density(z));
}
}
\seealso{
Direct INT \code{\link{DINT}}, indirect INT \code{\link{IINT}}, omnibus INT \code{\link{OINT}}.
}
