% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/createNode.R
\name{createNode}
\alias{createNode}
\title{Nodes}
\usage{
createNode(graph, .label = character(), ...)
}
\arguments{
\item{graph}{A graph object.}

\item{.label}{A character string.}

\item{...}{A named list. Node properties in the form key = value.}
}
\value{
A node object.
}
\description{
Create a node in the graph with the given label and properties.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

bob = createNode(graph, "Person", name = "Bob", age = 24, kids = c("Jenny", "Larry"))
charles = createNode(graph, c("Person", "Student"), name = "Charles", age = 21)

bob
charles

props = list(name="David", age = 26)
david = createNode(graph, "Person", props)

david
}
}

