% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/getSinglePath.R
\name{getSinglePath}
\alias{getSinglePath}
\title{Retrieve Paths with Cypher Queries}
\usage{
getSinglePath(graph, query, ...)
}
\arguments{
\item{graph}{A graph object.}

\item{query}{A character string.}

\item{...}{Parameters to pass to the query in the form key = value, if applicable.}
}
\value{
A path object.
}
\description{
Deprecated. Use \code{\link{cypherToList}}. Retrieve a single path from the graph with a Cypher query.
}
\examples{
\dontrun{
graph = startGraph("http://localhost:7474/db/data/")
clear(graph)

alice = createNode(graph, "Person", name = "Alice", age = 23)
bob = createNode(graph, "Person", name = "Bob", age = 22)
charles = createNode(graph, "Person", name = "Charles", age = 25)

createRel(alice, "KNOWS", bob)
createRel(alice, "KNOWS", charles)

query = "MATCH p = (:Person {name:'Alice'})-[:KNOWS]->(:Person {name:'Bob'}) RETURN p"

getSinglePath(graph, query)

query = "MATCH p = (:Person {name:'Alice'})-[:KNOWS]->(:Person {name:{name}}) RETURN p"

getSinglePath(graph, query, name = "Charles")
}
}
\seealso{
\code{\link{getPaths}}
}

