% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affine.R
\name{readAffine}
\alias{readAffine}
\title{Read an affine matrix from a file}
\usage{
readAffine(fileName, source = NULL, target = NULL, type = NULL)
}
\arguments{
\item{fileName}{A string giving the file name to read the affine matrix
from.}

\item{source}{The source image for the transformation. If \code{NULL}, the
file will be searched for a comment specifying the path to a NIfTI file.}

\item{target}{The target image for the transformation. If \code{NULL}, the
file will be searched for a comment specifying the path to a NIfTI file.}

\item{type}{The type of the affine matrix, which describes what convention
is it is stored with. Currently valid values are \code{"niftyreg"} and
\code{"fsl"} (for FSL FLIRT). If \code{NULL}, the function will look in
the file for a comment specifying the type.}
}
\value{
An matrix with class \code{"affine"}, converted to the NiftyReg
  convention and with \code{source} and \code{target} attributes set
  appropriately.
}
\description{
This function is used to read a 4x4 numeric matrix representing an affine
transformation from a file. It is a wrapper around \code{read.table} which
additionally ensures that required attributes are set. The type of the
matrix must be specified, as there are differing conventions across
software packages.
}
\examples{
print(readAffine(system.file("extdata","affine.txt",package="RNiftyReg")))

}
\author{
Jon Clayden <code@clayden.org>
}
\seealso{
\code{\link{read.table}}, \code{\link{writeAffine}}
}

